/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.basic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class AWTools {
    private static final DateTimeFormatter DATE_TIME_FORMAT_DD_MM_YYYY = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter DATE_TIME_FORMAT_YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @SafeVarargs
    public static <T> List<T> arrayList(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        boolean addAll = list.addAll(Arrays.asList(values));
        if (!addAll) {
            throw new IllegalStateException("There is a failure here.");
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> hashSet(T ... values) {
        HashSet<T> set = new HashSet<T>();
        boolean addAll = set.addAll(Arrays.asList(values));
        if (!addAll) {
            throw new IllegalStateException("There is a failure here.");
        }
        return set;
    }

    public static String toString(int[] arrayOfInts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arrayOfInts.length; ++i) {
            sb.append(arrayOfInts[i]);
            if (i >= arrayOfInts.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String toString(double value, String pattern, Locale locale) {
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        return df.format(value);
    }

    public static Date stringToDate(String string) throws ParseException {
        return AWTools.stringToDate(string, "dd.MM.yyyy");
    }

    public static LocalDate toLocalDate_DD_MM_YYYY(String date) {
        return LocalDate.parse(date, DATE_TIME_FORMAT_DD_MM_YYYY);
    }

    public static LocalDate toLocalDate_YYYY_MM_DD(String date) {
        return LocalDate.parse(date, DATE_TIME_FORMAT_YYYY_MM_DD);
    }

    public static Date stringToDate(String string, String format) throws ParseException {
        Validate.notNull((Object)string, (String)"string ist eine 'null' Referenz.");
        Validate.notNull((Object)format, (String)"format ist eine 'null' Referenz.");
        return new SimpleDateFormat(format).parse(string);
    }

    public static String stacktraceToString(Exception ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ex.printStackTrace(ps);
        return baos.toString();
    }

    public static String replacePlaceholder(String string, Map<String, String> placeholders) {
        String result = string;
        String[] keys = StringUtils.substringsBetween((String)string, (String)"${", (String)"}");
        if (keys != null) {
            for (String key : keys) {
                String value = placeholders.get(key);
                if (value == null) continue;
                String sb = "${" + key + "}";
                result = StringUtils.replace((String)result, (String)sb.toString(), (String)value);
            }
        }
        return result;
    }
}

