/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.basic;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.MaskFormatter;

public class NumberUtils {
    public static final String DEFAULT_DECIMAL_FORMAT = "###,###.##";
    public static final String DEFAULT_ZERO_FORMAT = "##,##0.00";
    private static final String EMPTY = "";
    private Locale locale = Locale.getDefault();
    private String pattern = "###,###.##";

    public static NumberUtils numbero(String pattern) {
        return NumberUtils.numbero(Locale.getDefault(), pattern);
    }

    public static NumberUtils numbero(Locale locale, String pattern) {
        NumberUtils utils = new NumberUtils(locale, pattern);
        return utils;
    }

    public NumberUtils(String _pattern) {
        this(Locale.getDefault(), _pattern);
    }

    public NumberUtils(Locale _locale, String _pattern) {
        this.setPatternAndLocale(_locale, _pattern);
    }

    private void setPatternAndLocale(Locale _locale, String _pattern) {
        this.locale = _locale == null ? Locale.getDefault() : _locale;
        this.pattern = _pattern == null ? DEFAULT_DECIMAL_FORMAT : _pattern;
    }

    private DecimalFormat createNumberFormatter() {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(this.locale);
        decimalFormat.applyPattern(this.pattern);
        return decimalFormat;
    }

    public MaskFormatter createFormatter(String mask) {
        MaskFormatter formatter;
        try {
            formatter = new MaskFormatter(mask);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        return formatter;
    }

    public int toInt(String value) {
        return this.toNumber(value).intValue();
    }

    public short toShort(String value) {
        return this.toNumber(value).shortValue();
    }

    public long toLong(String value) {
        return this.toNumber(value).longValue();
    }

    public double toDouble(String value) {
        return this.toNumber(value).doubleValue();
    }

    public float toFloat(String value) {
        return this.toNumber(value).floatValue();
    }

    public String formatLong(long value) {
        return this.format(new Double(value));
    }

    public String formatDouble(double value) {
        return this.format(new Double(value));
    }

    public String format(Number value) {
        DecimalFormat decimalFormat = this.createNumberFormatter();
        if (value == null) {
            return EMPTY;
        }
        return decimalFormat.format(value);
    }

    public Number toNumber(String value) {
        Number number;
        try {
            number = this.parseNumber(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        return number;
    }

    public Number parseNumber(String value) throws ParseException {
        DecimalFormat decimalFormat = this.createNumberFormatter();
        return decimalFormat.parse(value);
    }
}

