/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.basic.file;

import de.awtools.basic.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class AWToolsFileUtils {
    private static final Logger log = LoggerFactory.make();
    private static final String UP = "../";
    public static final String FILESEPARATOR = File.separator;
    public static final char WINFILE_SEPEATOR_CHAR = '/';
    public static final String WINFILE_SEPERATOR = "/";
    public static final Pattern WINDOWS_ROOT_PATTERN = Pattern.compile("^[a-zA-Z]:");

    private AWToolsFileUtils() {
    }

    public static InputStream classpathLoader(String resource) {
        return AWToolsFileUtils.class.getClassLoader().getResourceAsStream(resource);
    }

    public static boolean isDirectory(String dir) {
        if (!StringUtils.isBlank((String)dir)) {
            File outDir = new File(dir);
            return outDir.isDirectory();
        }
        return false;
    }

    public static URL createURL(String dirName, String fileName) {
        StringBuilder file = new StringBuilder();
        file.append("file:");
        file.append(dirName);
        file.append(System.getProperty("file.separator"));
        file.append(fileName);
        return AWToolsFileUtils.createURL(file.toString());
    }

    public static URL createURL(String fileName) {
        URL url;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            log.debug("Catched an MalformedURLException", (Throwable)ex);
            url = null;
        }
        return url;
    }

    public static void createFilePath(String basePath, String relativeFileName) {
        if (StringUtils.contains((String)relativeFileName, (char)'\\')) {
            AWToolsFileUtils.createFilePath(basePath, relativeFileName, '\\');
        } else if (StringUtils.contains((String)relativeFileName, (char)'/')) {
            AWToolsFileUtils.createFilePath(basePath, relativeFileName, '/');
        } else {
            log.debug("Directory creation not necessary!");
        }
    }

    private static void createFilePath(String basePath, String relativeFileName, char separator) {
        StringBuilder path = new StringBuilder(basePath);
        String[] split = StringUtils.split((String)relativeFileName, (char)separator);
        int max = split.length - 1;
        for (int i = 0; i < max; ++i) {
            if (!path.toString().endsWith(WINFILE_SEPERATOR) && !path.toString().endsWith("\\")) {
                path.append(FILESEPARATOR);
            }
            path.append(split[i]);
            File newDirFile = new File(path.toString());
            if (newDirFile.exists()) continue;
            if (log.isDebugEnabled()) {
                log.info("mkdir {}", (Object)path);
            }
            newDirFile.mkdirs();
        }
    }

    public static int countDirLevel(String fileName) {
        String newFileName = AWToolsFileUtils.normalizePath(fileName);
        return StringUtils.countMatches((String)newFileName, (String)WINFILE_SEPERATOR) - 1;
    }

    public static String pathToRoot(int level) {
        StringBuilder buf = new StringBuilder("./");
        for (int i = 0; i < level; ++i) {
            buf.append(UP);
        }
        return buf.toString();
    }

    public static String pathToRoot(String fileName) {
        return AWToolsFileUtils.pathToRoot(AWToolsFileUtils.countDirLevel(fileName));
    }

    public static List<File> findFiles(File basePath, String fileName) {
        String relativePath = "";
        String realFileName = fileName;
        if (StringUtils.contains((String)fileName, (String)WINFILE_SEPERATOR)) {
            relativePath = StringUtils.substringBeforeLast((String)fileName, (String)WINFILE_SEPERATOR);
            realFileName = StringUtils.substringAfterLast((String)fileName, (String)WINFILE_SEPERATOR);
        }
        if (log.isDebugEnabled()) {
            log.debug("basePath ......: " + basePath);
            log.debug("relativePath ..: " + relativePath);
            log.debug("realFileName ..: " + realFileName);
        }
        return AWToolsFileUtils.findFiles(basePath, relativePath, realFileName);
    }

    public static List<File> findFiles(File basePath, String relativePath, String fileName) {
        ArrayList<File> filesWithSameName = new ArrayList<File>();
        File fileInBase = new File(basePath, fileName);
        if (fileInBase.exists()) {
            filesWithSameName.add(fileInBase);
        }
        String newRelativePath = AWToolsFileUtils.normalizePath(relativePath);
        String[] split = StringUtils.split((String)newRelativePath, (String)WINFILE_SEPERATOR);
        StringBuilder intermediateDir = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            intermediateDir.append(split[i]).append(File.separatorChar);
            File currentDir = new File(basePath, intermediateDir.toString());
            File checkMyExistence = new File(currentDir, fileName);
            if (!checkMyExistence.exists()) continue;
            filesWithSameName.add(checkMyExistence);
        }
        return filesWithSameName;
    }

    public static String normalizePath(String fileName) {
        String newFileName = StringUtils.replace((String)fileName, (String)"\\", (String)WINFILE_SEPERATOR);
        newFileName = StringUtils.replace((String)newFileName, (String)"//", (String)WINFILE_SEPERATOR);
        newFileName = StringUtils.replace((String)newFileName, (String)"///", (String)WINFILE_SEPERATOR);
        if ((newFileName = StringUtils.replace((String)newFileName, (String)"/./", (String)WINFILE_SEPERATOR)).startsWith("./")) {
            newFileName = StringUtils.replace((String)newFileName, (String)".", (String)"", (int)1);
        }
        if (WINDOWS_ROOT_PATTERN.matcher(newFileName).find()) {
            newFileName = newFileName.substring(2);
        }
        if (!newFileName.startsWith(WINFILE_SEPERATOR)) {
            newFileName = WINFILE_SEPERATOR + newFileName;
        }
        if (newFileName.endsWith(WINFILE_SEPERATOR)) {
            newFileName = StringUtils.removeEnd((String)newFileName, (String)WINFILE_SEPERATOR);
        }
        return newFileName;
    }

    public static String getParent(String fileName) {
        String tmp = AWToolsFileUtils.normalizePath(fileName);
        if (StringUtils.contains((String)tmp, (String)WINFILE_SEPERATOR)) {
            return StringUtils.substringBeforeLast((String)tmp, (String)WINFILE_SEPERATOR);
        }
        return "";
    }

    public static String getFileName(String fileName) {
        String tmp = AWToolsFileUtils.normalizePath(fileName);
        if (StringUtils.contains((String)tmp, (String)WINFILE_SEPERATOR)) {
            return StringUtils.substringAfterLast((String)tmp, (String)WINFILE_SEPERATOR);
        }
        return tmp;
    }
}

