/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.basic.io;

import de.awtools.basic.LoggerFactory;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.UnhandledException;
import org.slf4j.Logger;

public class AWToolsIOUtils {
    private static final Logger log = LoggerFactory.make();

    public static InputStream stringToInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    public static Image loadImage(String resource) {
        return AWToolsIOUtils.loadImage(resource, AWToolsIOUtils.class);
    }

    public static Image loadImage(String resource, Class<?> classLoader) {
        try {
            URL imageURL = classLoader.getResource(resource);
            return ImageIO.read(imageURL);
        }
        catch (IOException ex) {
            log.error("Fehler: ", (Throwable)ex);
            throw new UnhandledException((Throwable)ex);
        }
    }

    public static File createTempDir() throws IOException {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((newTempDir = new File(sysTempDir, dirName = UUID.randomUUID().toString())).exists());
        if (newTempDir.mkdirs()) {
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }

    public static boolean recursiveDelete(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            for (File innerFile : fileOrDir.listFiles()) {
                if (FileUtils.deleteQuietly((File)innerFile)) continue;
                return false;
            }
        }
        return FileUtils.deleteQuietly((File)fileOrDir);
    }
}

