/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.basic.io;

import de.awtools.basic.LoggerFactory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;

public class FTPWrapper {
    private static final Logger log = LoggerFactory.make();
    private final FTPClient ftpClient = new FTPClient();

    public boolean connectAndLogin(String host, String userName, String password) throws IOException, UnknownHostException, FTPConnectionClosedException {
        boolean success = false;
        this.ftpClient.connect(host);
        int reply = this.ftpClient.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)reply)) {
            success = this.ftpClient.login(userName, password);
        }
        if (!success) {
            this.ftpClient.disconnect();
        }
        return success;
    }

    public void setPassiveMode(boolean setPassive) {
        if (setPassive) {
            this.ftpClient.enterLocalPassiveMode();
        } else {
            this.ftpClient.enterLocalActiveMode();
        }
    }

    public boolean ascii() throws IOException {
        return this.ftpClient.setFileType(0);
    }

    public boolean binary() throws IOException {
        return this.ftpClient.setFileType(2);
    }

    public boolean downloadFile(String serverFile, String localFile) throws IOException, FTPConnectionClosedException {
        boolean result = false;
        try (FileOutputStream out = new FileOutputStream(localFile);){
            log.info("Downloading file ->{}<- to local file ->{}<-.", (Object)serverFile, (Object)localFile);
            result = this.ftpClient.retrieveFile(serverFile, (OutputStream)out);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String localFile, String serverFile) throws IOException, FTPConnectionClosedException {
        FileInputStream in = null;
        boolean result = false;
        try {
            in = new FileInputStream(localFile);
            log.info("Downloading file ->{}<- to local file ->{}<-.", (Object)serverFile, (Object)localFile);
            result = this.ftpClient.storeFile(serverFile, (InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return result;
    }

    public List<String> listFileNames() throws IOException, FTPConnectionClosedException {
        FTPFile[] files = this.ftpClient.listFiles();
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            v.add(files[i].getName());
        }
        return v;
    }

    public String listFileNamesString() throws IOException, FTPConnectionClosedException {
        return this.listToString(this.listFileNames(), "\n");
    }

    public List<String> listSubdirNames() throws IOException, FTPConnectionClosedException {
        FTPFile[] files = this.ftpClient.listFiles();
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            v.add(files[i].getName());
        }
        return v;
    }

    public String listSubdirNamesString() throws IOException, FTPConnectionClosedException {
        return this.listToString(this.listSubdirNames(), "\n");
    }

    private String listToString(List<?> v, String delim) {
        StringBuffer sb = new StringBuffer();
        String s = "";
        Iterator<?> i = v.iterator();
        while (i.hasNext()) {
            sb.append(s).append(i.next().toString());
            s = delim;
        }
        return sb.toString();
    }

    public boolean changeWorkingDirectory(String directoryName) throws IOException {
        return this.ftpClient.changeWorkingDirectory(directoryName);
    }

    public void checkReplyCode() throws IOException {
        int reply = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            log.info("Error: {}", (Object)this.ftpClient.getReplyString());
            throw new RuntimeException();
        }
    }

    public void makeDirectory(String directoryName) throws IOException {
        this.ftpClient.makeDirectory(directoryName);
    }

    public void changeOrCreateDirectory(String rootDirectory, String directory) throws IOException {
        boolean ok = true;
        ok = ok && this.changeWorkingDirectory("/");
        boolean bl = ok = ok && this.changeWorkingDirectory(rootDirectory);
        if (!ok) {
            throw new IOException("Unable to change to the root directory.");
        }
        String[] dirs = StringUtils.split((String)directory, (char)'/');
        for (int i = 0; i < dirs.length; ++i) {
            if (this.changeWorkingDirectory(dirs[i])) {
                this.checkReplyCode();
                continue;
            }
            this.makeDirectory(dirs[i]);
            this.checkReplyCode();
            this.changeWorkingDirectory(dirs[i]);
            this.checkReplyCode();
        }
    }

    public void close() {
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

