/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.cookie;

import de.awtools.registration.cookie.CookieJson;
import de.awtools.registration.cookie.CookieService;
import de.awtools.registration.time.DateTimeJson;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cookie"})
public class CookieController {
    private final CookieService cookieService;

    @Autowired
    public CookieController(CookieService cookieService) {
        this.cookieService = cookieService;
    }

    @CrossOrigin
    @GetMapping(path={"/ping"}, produces={"application/json; charset=utf-8"})
    public DateTimeJson ping() {
        DateTimeJson dateTimeJson = new DateTimeJson();
        return dateTimeJson.setDateTime(LocalDateTime.now());
    }

    @CrossOrigin
    @PostMapping(path={"confirmCookie"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public DateTimeJson confirmCookie(@Valid @RequestBody CookieJson cookieJson, @RequestHeader(value="User-Agent") String userAgent, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie("confirmCookie", Boolean.toString(cookieJson.isAcceptCookies()));
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
        DateTimeJson dateTimeJson = new DateTimeJson();
        return dateTimeJson.setDateTime(this.cookieService.storeCookieAcceptance(cookieJson.getWebsite(), userAgent, request.getRemoteAddr(), cookieJson.isAcceptCookies()).getCreated());
    }
}

