/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.mail;

import de.awtools.registration.mail.MailConfiguration;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendMailService {
    private static final Logger LOG = LoggerFactory.getLogger(SendMailService.class);
    private final MailConfiguration mailConfiguration;

    @Autowired
    public SendMailService(MailConfiguration mailConfiguration) {
        this.mailConfiguration = mailConfiguration;
    }

    public void sendMail(String from, String recipient, String subject, String messageText) {
        Session session = Session.getInstance((Properties)this.mailConfiguration.properties(), (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SendMailService.this.mailConfiguration.getMailAuthenticationUser(), SendMailService.this.mailConfiguration.getMailAuthenticationPassword());
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
            message.setSubject(subject);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)messageText, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (MessagingException ex) {
            LOG.error("Mail sending failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

