/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.ping;

import de.awtools.registration.VersionJson;
import de.awtools.registration.config.PersistenceConfiguration;
import de.awtools.registration.time.DateTimeJson;
import java.time.LocalDateTime;
import java.util.Properties;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PingController {
    private static final String version;
    private static final String artifactId;
    private static final String groupId;
    private static final VersionJson VERSION_JSON;
    private final PersistenceConfiguration config;

    public PingController(PersistenceConfiguration config) {
        this.config = config;
    }

    @CrossOrigin(origins={"http://andre-winkler.de"})
    @GetMapping(path={"/version"}, produces={"application/json; charset=utf-8"})
    public VersionJson versionInfo() {
        return VERSION_JSON;
    }

    @CrossOrigin
    @GetMapping(path={"/ping"}, produces={"application/json; charset=utf-8"})
    public DateTimeJson ping() {
        DateTimeJson dateTimeJson = new DateTimeJson();
        dateTimeJson.setDateTime(LocalDateTime.now());
        return dateTimeJson;
    }

    @CrossOrigin
    @GetMapping(path={"/database"}, produces={"application/json; charset=utf-8"})
    public String database() {
        return this.config.getUrl();
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(PingController.class.getResourceAsStream("/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        version = properties.getProperty("version");
        artifactId = properties.getProperty("artifactId");
        groupId = properties.getProperty("groupId");
        VERSION_JSON = VersionJson.of(groupId, artifactId, version);
    }
}

