/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.register;

import de.awtools.registration.Token;
import de.awtools.registration.register.DefaultRegistrationValidation;
import de.awtools.registration.register.RegistrationJson;
import de.awtools.registration.register.RegistrationService;
import de.awtools.registration.register.RegistrationValidationJson;
import de.awtools.registration.register.Validation;
import de.awtools.registration.register.ValidationResultMapper;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/registration"})
public class RegistrationController {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationController.class);
    private final RegistrationService registrationService;

    @Autowired
    public RegistrationController(RegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @CrossOrigin
    @PostMapping(path={"/register"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<RegistrationValidationJson> register(@Valid @RequestBody RegistrationJson registration) {
        DefaultRegistrationValidation validation = this.registrationService.registerNewAccount(registration);
        return this.toResponse(validation);
    }

    private boolean validateApiKey(String apiKey) {
        return false;
    }

    @CrossOrigin
    @PostMapping(path={"/validate"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<RegistrationValidationJson> validate(@RequestBody RegistrationJson registration) {
        DefaultRegistrationValidation validation = this.registrationService.validate(registration.getNickname(), registration.getEmail(), registration.getApplicationName());
        return this.toResponse(validation);
    }

    @CrossOrigin
    @PostMapping(value={"/confirm/{token}"})
    public ResponseEntity<RegistrationValidationJson> confirm(@PathVariable String token) {
        DefaultRegistrationValidation validation = this.registrationService.confirmAccount(new Token(token));
        return this.toResponse(validation);
    }

    @CrossOrigin
    @PostMapping(path={"/create"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<RegistrationValidationJson> create(@Valid @RequestBody RegistrationJson registration) {
        DefaultRegistrationValidation validation = this.registrationService.createAccount(registration);
        return this.toResponse(validation);
    }

    private ResponseEntity<RegistrationValidationJson> toResponse(Validation validation) {
        return ValidationResultMapper.of(validation).ifValid(RegistrationController::registrationIsValid).orElse(RegistrationController::registrationFailed);
    }

    private static ResponseEntity<RegistrationValidationJson> registrationIsValid(Validation validation) {
        return ResponseEntity.ok((Object)RegistrationValidationJson.of(validation));
    }

    private static ResponseEntity<RegistrationValidationJson> registrationFailed(Validation validation) {
        LOG.info("Registration failed: {}", (Object)validation);
        return ResponseEntity.badRequest().body((Object)RegistrationValidationJson.of(validation));
    }
}

