/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.register;

import de.awtools.registration.RequestValidationException;
import de.awtools.registration.Token;
import de.awtools.registration.mail.SendMailService;
import de.awtools.registration.password.PasswordEncoderWrapper;
import de.awtools.registration.register.DefaultRegistrationValidation;
import de.awtools.registration.register.RegistrationEntity;
import de.awtools.registration.register.RegistrationJson;
import de.awtools.registration.register.RegistrationRepository;
import de.awtools.registration.register.Validation;
import de.awtools.registration.time.TimeService;
import de.awtools.registration.user.ApplicationEntity;
import de.awtools.registration.user.ApplicationRepository;
import de.awtools.registration.user.Email;
import de.awtools.registration.user.Password;
import de.awtools.registration.user.UserAccountEntity;
import de.awtools.registration.user.UserAccountRepository;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistrationService {
    @Autowired
    private PasswordEncoderWrapper passwordEncoder;
    @Autowired
    private RegistrationRepository registrationRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private UserAccountRepository userAccountRepository;
    @Autowired
    private TimeService timeService;
    @Autowired
    private SendMailService sendMailService;

    @Transactional
    public DefaultRegistrationValidation registerNewAccount(RegistrationJson registration) throws RequestValidationException {
        Optional<RegistrationEntity> registrationCheck;
        Optional<UserAccountEntity> userAccountCheck;
        DefaultRegistrationValidation registrationValidation = new DefaultRegistrationValidation(registration.getNickname(), registration.getApplicationName());
        if (!registration.isAcceptCookie()) {
            registrationValidation.addValidationCode(Validation.ValidationCode.MISSING_ACCEPT_COOKIE);
        }
        if (!registration.isAcceptMail()) {
            registrationValidation.addValidationCode(Validation.ValidationCode.MISSING_ACCEPT_EMAIL);
        }
        if (StringUtils.isBlank((CharSequence)registration.getPassword()) || registration.getPassword().length() < 5) {
            registrationValidation.addValidationCode(Validation.ValidationCode.PASSWORD_TOO_SHORT);
        }
        if (StringUtils.isBlank((CharSequence)registration.getNickname())) {
            registrationValidation.addValidationCode(Validation.ValidationCode.NICKNAME_IS_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)registration.getFirstname())) {
            registrationValidation.addValidationCode(Validation.ValidationCode.FIRSTNAME_IS_EMPTY);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)registration.getNickname(), (CharSequence[])new CharSequence[]{registration.getPassword()})) {
            registrationValidation.addValidationCode(Validation.ValidationCode.PASSWORD_IS_TOO_SIMPEL);
        }
        if (StringUtils.isBlank((CharSequence)registration.getEmail())) {
            registrationValidation.addValidationCode(Validation.ValidationCode.EMAIL_IS_EMPTY);
        } else {
            if (!EmailValidator.getInstance().isValid(registration.getEmail())) {
                registrationValidation.addValidationCode(Validation.ValidationCode.EMAIL_IS_NOT_VALID);
            }
            if (this.registrationRepository.findByEmail(Email.of(registration.getEmail())).isPresent()) {
                registrationValidation.addValidationCode(Validation.ValidationCode.EMAIL_IS_RESERVED);
            }
        }
        Optional<ApplicationEntity> application = this.applicationRepository.findByName(registration.getApplicationName());
        if (application.isEmpty()) {
            registrationValidation.addValidationCode(Validation.ValidationCode.UNKNOWN_APPLICATION);
        }
        if ((userAccountCheck = this.userAccountRepository.findByNickname(registration.getNickname())).isPresent()) {
            registrationValidation.addValidationCode(Validation.ValidationCode.KNOWN_NICKNAME);
        }
        if ((registrationCheck = this.registrationRepository.findByNickname(registration.getNickname())).isPresent()) {
            registrationValidation.addValidationCode(Validation.ValidationCode.KNOWN_NICKNAME);
        }
        if (registrationValidation.ok()) {
            RegistrationEntity registrationEntity = this.createRegistration(registration);
            this.registrationRepository.save(registrationEntity);
            registrationValidation.addValidationCode(Validation.ValidationCode.OK);
        }
        return registrationValidation;
    }

    private RegistrationEntity createRegistration(RegistrationJson registration) {
        LocalDateTime now = this.timeService.now();
        RegistrationEntity registrationEntity = new RegistrationEntity();
        registrationEntity.setNickname(registration.getNickname());
        registrationEntity.setFirstname(registration.getFirstname());
        registrationEntity.setName(registration.getName());
        registrationEntity.setPassword(this.passwordEncoder.encode(Password.decoded(registration.getPassword())));
        registrationEntity.setEmail(Email.of(registration.getEmail()));
        registrationEntity.setCreated(now);
        UUID token = UUID.randomUUID();
        registrationEntity.setToken(new Token(token.toString()));
        registrationEntity.setApplication(registration.getApplicationName());
        registrationEntity.setConfirmed(false);
        registrationEntity.setAcceptCookie(registration.isAcceptCookie());
        registrationEntity.setAcceptMail(registration.isAcceptMail());
        registrationEntity.setSupplement(registration.getSupplement());
        return registrationEntity;
    }

    @Transactional
    public DefaultRegistrationValidation restartAccount(RegistrationJson registration) throws RequestValidationException {
        this.registrationRepository.deleteByEmail(Email.of(registration.getEmail()));
        return this.registerNewAccount(registration);
    }

    @Transactional
    public DefaultRegistrationValidation confirmAccount(Token token) throws RequestValidationException {
        Optional<RegistrationEntity> optionalRegistration = this.registrationRepository.findByToken(token);
        if (optionalRegistration.isEmpty()) {
            return new DefaultRegistrationValidation(null, null, Validation.ValidationCode.UNKNOWN_TOKEN);
        }
        RegistrationEntity registration = optionalRegistration.get();
        registration.setConfirmed(true);
        ApplicationEntity application = this.validateApplication(registration.getNickname(), registration.getApplication());
        UserAccountEntity newUserAccount = new UserAccountEntity(this.timeService.now(), registration);
        application.addUser(newUserAccount);
        this.userAccountRepository.save(newUserAccount);
        return new DefaultRegistrationValidation(registration.getNickname(), registration.getApplication(), Validation.ValidationCode.OK);
    }

    @Transactional
    public DefaultRegistrationValidation validate(String nickname, String email, String applicationName) throws RequestValidationException {
        this.validateApplication(nickname, applicationName);
        Optional<RegistrationEntity> registrationDefined = this.registrationRepository.findByNickname(nickname);
        if (registrationDefined.isPresent()) {
            return new DefaultRegistrationValidation(nickname, applicationName, Validation.ValidationCode.KNOWN_NICKNAME);
        }
        registrationDefined = this.registrationRepository.findByEmail(Email.of(email));
        if (registrationDefined.isPresent()) {
            return new DefaultRegistrationValidation(nickname, applicationName, Validation.ValidationCode.KNOWN_MAIL_ADDRESS);
        }
        return new DefaultRegistrationValidation(nickname, applicationName, Validation.ValidationCode.OK);
    }

    private ApplicationEntity validateApplication(String nickname, String applicationName) throws RequestValidationException {
        ApplicationEntity application = this.applicationRepository.findByName(applicationName).orElseThrow(() -> new RequestValidationException(new DefaultRegistrationValidation(nickname, applicationName, Validation.ValidationCode.UNKNOWN_APPLICATION)));
        return application;
    }

    @Transactional
    public DefaultRegistrationValidation createAccount(RegistrationJson registration) {
        DefaultRegistrationValidation registrationValidation = this.registerNewAccount(registration);
        if (registrationValidation.isBad()) {
            return registrationValidation;
        }
        UserAccountEntity userAccount = this.registrationRepository.findByNickname(registration.getNickname()).map(this::confirmAccount).map(this::createUserAccountEntity).orElseThrow();
        this.applicationRepository.findByName(registration.getApplicationName()).map(app -> this.addUserAccountToApplication((ApplicationEntity)app, userAccount));
        return new DefaultRegistrationValidation(registration.getNickname(), registration.getApplicationName(), Validation.ValidationCode.OK);
    }

    private RegistrationEntity confirmAccount(RegistrationEntity registration) {
        registration.setConfirmed(true);
        return registration;
    }

    private UserAccountEntity createUserAccountEntity(RegistrationEntity registration) {
        return new UserAccountEntity(this.timeService.now(), registration);
    }

    private UserAccountEntity addUserAccountToApplication(ApplicationEntity application, UserAccountEntity userAccount) {
        application.addUser(userAccount);
        this.userAccountRepository.save(userAccount);
        return userAccount;
    }
}

