/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.security;

import de.awtools.registration.security.AuthenticationService;
import de.awtools.registration.security.Token;
import de.awtools.registration.user.Password;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authentication"})
public class AuthenticationController {
    public static final String TOKEN_PREFIX = "Bearer ";
    public static final String HEADER_STRING = "Authorization";
    private final AuthenticationService authenticationService;

    public AuthenticationController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @CrossOrigin
    @PostMapping(path={"/login"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<Token> login(@RequestParam String nickname, @RequestParam String password) {
        Optional<Token> loginToken = this.authenticationService.login(nickname, Password.decoded(password));
        return loginToken.map(ResponseEntity::ok).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build());
    }

    @CrossOrigin
    @PostMapping(path={"/refresh"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<Token> refresh(@RequestHeader(value="Authorization") String token) {
        throw new NotImplementedException();
    }

    @CrossOrigin
    @PostMapping(path={"/logout"}, headers={"Content-type=application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<Void> logout(@RequestHeader(value="Authorization") String token) {
        this.authenticationService.logout(Token.of(token));
        return ResponseEntity.ok().build();
    }
}

