/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.security;

import de.awtools.registration.password.PasswordEncoderWrapper;
import de.awtools.registration.security.AWUserDetails;
import de.awtools.registration.security.AuthenticationRepository;
import de.awtools.registration.security.Token;
import de.awtools.registration.time.TimeService;
import de.awtools.registration.user.Password;
import de.awtools.registration.user.PrivilegeEntity;
import de.awtools.registration.user.PrivilegeRepository;
import de.awtools.registration.user.UserAccountEntity;
import de.awtools.registration.user.UserAccountRepository;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.security.KeyPair;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationService
implements UserDetailsService {
    private static final long EXPIRATION_DAYS = 3L;
    private static final String ISSUER = "awregister";
    private static final ZoneId DEFAULT_TIME_ZONE_ID = ZoneId.systemDefault();
    private static final KeyPair KEY_PAIR = Keys.keyPairFor((SignatureAlgorithm)SignatureAlgorithm.RS256);
    private final AuthenticationRepository authenticationRepository;
    private final UserAccountRepository userAccountRepository;
    private final PrivilegeRepository privilegeRepository;
    private final TimeService timeService;
    private final PasswordEncoderWrapper passwordEncoderWrapper;

    @Autowired
    public AuthenticationService(AuthenticationRepository authenticationRepository, UserAccountRepository userAccountRepository, PrivilegeRepository privilegeRepository, TimeService timeService, PasswordEncoderWrapper passwordEncoderWrapper) {
        this.authenticationRepository = authenticationRepository;
        this.userAccountRepository = userAccountRepository;
        this.privilegeRepository = privilegeRepository;
        this.timeService = timeService;
        this.passwordEncoderWrapper = passwordEncoderWrapper;
    }

    public Optional<Token> login(String nickname, Password decodedPassword) {
        Optional<UserAccountEntity> user = this.userAccountRepository.findByNickname(nickname).filter(p -> this.passwordEncoderWrapper.validate(decodedPassword, p.getPassword()));
        return user.map(UserAccountEntity::getNickname).map(this::token);
    }

    public void logout(Token token) {
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserAccountEntity user = this.userAccountRepository.findByNickname(username).orElseThrow(() -> new UsernameNotFoundException("Unknown user with nickname=[" + username + "]."));
        AWUserDetails.AWUserDetailsBuilder userDetailsBuilder = AWUserDetails.AWUserDetailsBuilder.of(user.getNickname(), user.getPassword().get());
        Set<PrivilegeEntity> privileges = this.privilegeRepository.findByNickname(user.getNickname());
        for (PrivilegeEntity privilege : privileges) {
            userDetailsBuilder.addGrantedAuthority((GrantedAuthority)new SimpleGrantedAuthority(privilege.getName()));
        }
        return userDetailsBuilder.build();
    }

    Token token(String nickname) {
        LocalDateTime tokenExpiration = this.timeService.now().plusDays(3L);
        String jws = Jwts.builder().setSubject(nickname).setIssuer(ISSUER).setIssuedAt(this.timeService.currently()).setExpiration(TimeService.convertToDateViaInstant(DEFAULT_TIME_ZONE_ID, tokenExpiration)).signWith((Key)KEY_PAIR.getPrivate()).compact();
        return new Token(jws);
    }
}

