/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.user;

import de.awtools.registration.user.UserAccountEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NaturalId;

@Entity(name="Application")
@Table(name="application")
public class ApplicationEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @NaturalId
    @NotNull
    @Column(name="name")
    private String name;
    @Column(name="description")
    private String description;
    @ManyToMany
    @JoinTable(name="useraccount_application", joinColumns={@JoinColumn(name="application_ref")}, inverseJoinColumns={@JoinColumn(name="useraccount_ref")})
    private Set<UserAccountEntity> userAccounts = new HashSet<UserAccountEntity>();

    public Long getId() {
        return this.id;
    }

    void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addUser(UserAccountEntity userAccount) {
        userAccount.getApplications().add(this);
        this.userAccounts.add(userAccount);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationEntity other = (ApplicationEntity)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class ApplicationBuilder {
        private String name;

        public static ApplicationBuilder of(String name) {
            ApplicationBuilder builder = new ApplicationBuilder();
            builder.name = name;
            return builder;
        }

        public ApplicationEntity description(String description) {
            ApplicationEntity app = new ApplicationEntity();
            app.setName(this.name);
            app.setDescription(description);
            return app;
        }
    }
}

