/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.user;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Embeddable
public class Password {
    @NotNull
    @Column(name="password")
    @Size(min=8, max=60)
    private @NotNull @Size(min=8, max=60) String value;
    @Transient
    private final boolean encoded;

    public Password() {
        this.encoded = true;
    }

    public Password(String password) {
        this.value = password;
        this.encoded = true;
    }

    public Password(String password, boolean encoded) {
        this.value = password;
        this.encoded = encoded;
    }

    public String get() {
        return this.value;
    }

    public Password set(String password) {
        this.value = password;
        return this;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public boolean isDecoded() {
        return !this.encoded;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Password other = (Password)obj;
        return StringUtils.equals((CharSequence)this.value, (CharSequence)other.value);
    }

    public static boolean isEqual(Password p1, Password p2) {
        if (p1.isEncoded() && p2.isEncoded()) {
            return p1.equals(p2);
        }
        return false;
    }

    public static Password encoded(String password) {
        return new Password(password, true);
    }

    public static Password decoded(String password) {
        return new Password(password, false);
    }
}

