/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.user;

import de.awtools.registration.register.RegistrationEntity;
import de.awtools.registration.user.ApplicationEntity;
import de.awtools.registration.user.Email;
import de.awtools.registration.user.Password;
import de.awtools.registration.user.RoleEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NaturalId;

@Entity(name="UserAccount")
@Table(name="useraccount")
public class UserAccountEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @NaturalId
    @NotNull
    @Column(name="nickname")
    private String nickname;
    @NotNull
    @Column(name="name")
    private String name;
    @NotNull
    @Column(name="firstname")
    private String firstname;
    @NotNull
    @Embedded
    private Email email;
    @NotNull
    @Embedded
    private Password password;
    @Column(name="created")
    private LocalDateTime created;
    @Column(name="last_change")
    private LocalDateTime lastChange;
    @Column(name="enabled")
    private boolean enabled;
    @Column(name="expired")
    private boolean expired;
    @Column(name="locked")
    private boolean locked;
    @Column(name="credential_expired")
    private boolean credentialExpired;
    @Column(name="acceptmail")
    private boolean acceptMail;
    @Column(name="acceptcookie")
    private boolean acceptCookie;
    @ManyToMany(mappedBy="userAccounts")
    private Set<ApplicationEntity> applications = new HashSet<ApplicationEntity>();
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="useraccount_role", joinColumns={@JoinColumn(name="useraccount_ref")}, inverseJoinColumns={@JoinColumn(name="role_ref")})
    private Set<RoleEntity> roles = new HashSet<RoleEntity>();

    public UserAccountEntity() {
    }

    public UserAccountEntity(LocalDateTime createdAt, RegistrationEntity registration) {
        this.created = createdAt;
        this.credentialExpired = false;
        this.email = registration.getEmail();
        this.enabled = true;
        this.expired = false;
        this.firstname = registration.getFirstname();
        this.lastChange = this.created;
        this.locked = false;
        this.name = registration.getName();
        this.nickname = registration.getNickname();
        this.password = registration.getPassword();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public Password getPassword() {
        return this.password;
    }

    public void setPassword(Password password) {
        this.password = password;
    }

    public Email getEmail() {
        return this.email;
    }

    public void setEmail(Email email) {
        this.email = email;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public LocalDateTime getLastChange() {
        return this.lastChange;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLastChange(LocalDateTime lastChange) {
        this.lastChange = lastChange;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isCredentialExpired() {
        return this.credentialExpired;
    }

    public void setCredentialExpired(boolean credentialExpired) {
        this.credentialExpired = credentialExpired;
    }

    public void setAcceptMail(boolean acceptMail) {
        this.acceptMail = acceptMail;
    }

    public boolean isAcceptingMail() {
        return this.acceptMail;
    }

    public void setAcceptCookie(boolean acceptCookie) {
        this.acceptCookie = acceptCookie;
    }

    public boolean isAcceptingCookie() {
        return this.acceptCookie;
    }

    Set<ApplicationEntity> getApplications() {
        return this.applications;
    }

    public void addRole(RoleEntity role) {
        this.roles.add(role);
        role.getUsers().add(this);
    }

    public void removeRole(RoleEntity role) {
        this.roles.remove(role);
        role.getUsers().remove(this);
    }

    public Set<RoleEntity> getRoles() {
        return this.roles;
    }

    public boolean hasRole(RoleEntity role) {
        return this.roles.contains(role);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nickname == null ? 0 : this.nickname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAccountEntity other = (UserAccountEntity)obj;
        return !(this.nickname == null ? other.nickname != null : !this.nickname.equals(other.nickname));
    }

    public static class UserAccountBuilder {
        private String nickname;
        private String password;
        private String firstname;
        private String name;
        private LocalDateTime created;
        private Email email;

        private UserAccountBuilder() {
        }

        public static UserAccountBuilder of(String nickname, String password) {
            UserAccountBuilder ub = new UserAccountBuilder();
            ub.nickname = nickname;
            ub.password = password;
            return ub;
        }

        public UserAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserAccountBuilder firstname(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public UserAccountBuilder created(LocalDateTime localDateTime) {
            this.created = localDateTime;
            return this;
        }

        public UserAccountBuilder createdNow() {
            this.created = LocalDateTime.now();
            return this;
        }

        public UserAccountBuilder email(Email email) {
            this.email = email;
            return this;
        }

        public UserAccountEntity build() {
            UserAccountEntity ue = new UserAccountEntity();
            ue.setNickname(this.nickname);
            ue.setPassword(new Password(this.password));
            ue.setFirstname(this.firstname);
            ue.setName(this.name);
            ue.setCreated(this.created);
            ue.setEmail(this.email);
            return ue;
        }
    }
}

