/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.assets;

import de.awtools.registration.time.DateTimeJson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/assets"})
public class AssetsController {
    @GetMapping(path={"/ping"}, produces={"application/json; charset=utf-8"})
    public DateTimeJson ping() {
        DateTimeJson dateTimeJson = new DateTimeJson();
        return dateTimeJson.setDateTime(LocalDateTime.now());
    }

    @GetMapping(path={"/{resource}"}, produces={"application/json; charset=utf-8"})
    public String resource(@PathVariable String resource) throws IOException {
        try (InputStream resourceAsStream = AssetsController.class.getResourceAsStream("/assets/" + resource);){
            String string = new String(Objects.requireNonNull(resourceAsStream).readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

