/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.config;

import de.awtools.registration.RequestValidationException;
import de.awtools.registration.register.Validation;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalExceptionAdvice
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={RequestValidationException.class})
    protected ResponseEntity<Object> handleConflict(Exception ex, WebRequest request) {
        JsonObjectBuilder json = Json.createObjectBuilder();
        if (ex instanceof RequestValidationException) {
            RequestValidationException rvex = (RequestValidationException)ex;
            json.add("nickname", rvex.getValidation().getNickname());
            json.add("applicationName", rvex.getValidation().getApplicationName());
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (Validation.ValidationCode vc : rvex.getValidation().getValidationCodes()) {
                arrayBuilder.add(vc.name());
            }
            json.add("validationCode", (JsonValue)arrayBuilder.build());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return this.handleExceptionInternal(ex, this.jsonToString(json), headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
    }

    private String jsonToString(JsonObjectBuilder jsonBuilder) {
        String jsonString;
        try (StringWriter writer = new StringWriter();){
            Json.createWriter((Writer)writer).write((JsonStructure)jsonBuilder.build());
            jsonString = ((Object)writer).toString();
        }
        catch (IOException ioex) {
            jsonString = ioex.getLocalizedMessage();
        }
        return jsonString;
    }
}

