/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.config;

import de.awtools.registration.user.UserAccountEntity;
import de.awtools.registration.user.UserAccountRepository;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserAccountDetailsService
implements UserDetailsService {
    private final UserAccountRepository userRepository;

    @Autowired
    public UserAccountDetailsService(UserAccountRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String nickname) {
        UserAccountEntity user = this.userRepository.findByNickname(nickname).orElseThrow(() -> new UsernameNotFoundException(nickname));
        return new UserAccountDetails(user);
    }

    public static class UserAccountDetails
    implements UserDetails {
        private static final long serialVersionUID = -7882416572804994114L;
        private UserAccountEntity user;

        public UserAccountDetails(UserAccountEntity user) {
            this.user = user;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return null;
        }

        public String getPassword() {
            return this.user.getPassword().get();
        }

        public String getUsername() {
            return this.user.getNickname();
        }

        public boolean isAccountNonExpired() {
            return !this.user.isExpired();
        }

        public boolean isAccountNonLocked() {
            return !this.user.isLocked();
        }

        public boolean isCredentialsNonExpired() {
            return !this.user.isCredentialExpired();
        }

        public boolean isEnabled() {
            return this.user.isEnabled();
        }
    }
}

