/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.function;

import de.awtools.registration.function.CheckedSupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class Result<V, E extends Throwable> {
    private final V value;
    private final E error;

    private Result(V value, E error) {
        this.value = value;
        this.error = error;
    }

    public static <V, E extends Throwable> Result<V, E> failure(E error) {
        return new Result<Object, E>(null, Objects.requireNonNull(error));
    }

    public static <V, E extends Throwable> Result<V, E> success(V value) {
        return new Result<V, Object>(Objects.requireNonNull(value), null);
    }

    public static <V, E extends Throwable> Result<V, E> attempt(CheckedSupplier<? extends V, ? extends E> p) {
        try {
            return Result.success(p.get());
        }
        catch (Throwable e) {
            Throwable err = e;
            return Result.failure(err);
        }
    }

    public <T> Result<T, E> map(Function<? super V, ? extends T> mapper) {
        return Optional.ofNullable(this.error).map((? super T e) -> Result.failure(e)).orElseGet(() -> Result.success(mapper.apply((V)this.value)));
    }

    public V orElseThrow() throws E {
        return Optional.ofNullable(this.value).orElseThrow(() -> this.error);
    }
}

