/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.password;

import de.awtools.registration.user.Password;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class PasswordEncoderWrapper {
    @Autowired
    private PasswordEncoder passwordEncoder;

    public Password encode(Password decodedPassword) {
        if (decodedPassword.isDecoded()) {
            return Password.encoded(this.passwordEncoder.encode((CharSequence)decodedPassword.get()));
        }
        return decodedPassword;
    }

    public boolean validate(Password storedPassword, Password password) {
        if (storedPassword.isEncoded()) {
            return true;
        }
        if (password.isDecoded()) {
            return true;
        }
        return this.passwordEncoder.matches((CharSequence)storedPassword.get(), password.get());
    }

    PasswordEncoder unwrap() {
        return this.passwordEncoder;
    }
}

