/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.register;

import de.awtools.registration.register.Validation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultRegistrationValidation
implements Validation {
    private final String nickname;
    private final String applicationName;
    private final Set<Validation.ValidationCode> validationCodes = new HashSet<Validation.ValidationCode>();

    public DefaultRegistrationValidation(String nickname, String applicationName) {
        this(nickname, applicationName, null);
    }

    public DefaultRegistrationValidation(String nickname, String applicationName, Validation.ValidationCode code) {
        this.nickname = nickname;
        this.applicationName = applicationName;
        if (code != null) {
            this.validationCodes.add(code);
        }
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public Set<Validation.ValidationCode> getValidationCodes() {
        return Collections.unmodifiableSet(this.validationCodes);
    }

    public void addValidationCode(Validation.ValidationCode validationCode) {
        this.validationCodes.add(validationCode);
    }

    @Override
    public boolean ok() {
        return this.validationCodes.size() == 0 || this.validationCodes.size() == 1 && this.validationCodes.contains((Object)Validation.ValidationCode.OK);
    }

    public String toString() {
        return String.format("RegistrationValidationJson nickname=[%s], code=[%s]", this.nickname, this.validationCodes);
    }
}

