/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public final class AWUserDetails
implements UserDetails {
    private static final long serialVersionUID = -3173954379673736025L;
    private final String nickname;
    private final String password;
    private final List<GrantedAuthority> authorities;

    private AWUserDetails(String nickname, String password, List<GrantedAuthority> authorities) {
        this.nickname = nickname;
        this.password = password;
        this.authorities = authorities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.unmodifiableCollection(this.authorities);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.nickname;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public static class AWUserDetailsBuilder {
        private String nickname;
        private String password;
        private List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();

        private AWUserDetailsBuilder() {
        }

        public static AWUserDetailsBuilder of(String nickname, String password) {
            AWUserDetailsBuilder builder = new AWUserDetailsBuilder();
            builder.nickname = nickname;
            builder.password = password;
            return builder;
        }

        public AWUserDetailsBuilder addGrantedAuthority(GrantedAuthority grantedAuthority) {
            this.authorities.add(grantedAuthority);
            return this;
        }

        public AWUserDetails build() {
            return new AWUserDetails(this.nickname, this.password, this.authorities);
        }
    }
}

