/*
 * Decompiled with CFR 0.152.
 */
package de.awtools.registration.user;

import de.awtools.registration.user.PrivilegeEntity;
import de.awtools.registration.user.UserAccountEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NaturalId;

@Entity(name="Role")
@Table(name="role")
public class RoleEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    private Long id;
    @NaturalId
    @Column(name="name", length=50, nullable=false, unique=true)
    private String name;
    @ManyToMany(mappedBy="roles")
    private Set<UserAccountEntity> users = new HashSet<UserAccountEntity>();
    @ManyToMany
    @JoinTable(name="role_privilege", joinColumns={@JoinColumn(name="role_ref", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="privilege_ref", referencedColumnName="id")})
    private Set<PrivilegeEntity> privileges = new HashSet<PrivilegeEntity>();

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Set<UserAccountEntity> getUsers() {
        return this.users;
    }

    public void addPrivilege(PrivilegeEntity ... privileges) {
        for (PrivilegeEntity privilege : privileges) {
            this.privileges.add(privilege);
            privilege.getRoles().add(this);
        }
    }

    public void addPrivileges(Collection<PrivilegeEntity> privileges) {
        privileges.forEach(pv -> this.addPrivilege((PrivilegeEntity)pv));
    }

    public Set<PrivilegeEntity> getPrivileges() {
        return this.privileges;
    }

    public boolean hasPrivilege(PrivilegeEntity privilege) {
        return this.privileges.contains(privilege);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleEntity)) {
            return false;
        }
        RoleEntity other = (RoleEntity)o;
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public static class RoleBuilder {
        private RoleBuilder() {
        }

        public static RoleEntity of(String name) {
            RoleEntity role = new RoleEntity();
            role.setName(name);
            return role;
        }
    }
}

