/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.web.JsonBuilder;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GameResultJson;
import de.winkler.betoffice.storage.Game;
import java.util.List;
import java.util.stream.Collectors;

public class GameJsonMapper {
    public GameJson map(Game game, GameJson gameJson) {
        gameJson.setId(game.getId());
        gameJson.setRoundId(game.getGameList().getId());
        gameJson.setOpenligaid(game.getOpenligaid());
        gameJson.setIndex(game.getIndex());
        gameJson.setFinished(game.isPlayed());
        gameJson.setKo(game.isKo());
        gameJson.setDateTime(game.getDateTime());
        GameResultJson halfTimeGoals = JsonBuilder.toJson(game.getHalfTimeGoals());
        gameJson.setHalfTimeResult(halfTimeGoals);
        GameResultJson gameResult = JsonBuilder.toJson(game.getResult());
        gameJson.setResult(gameResult);
        GameResultJson penaltyGoals = JsonBuilder.toJson(game.getPenaltyGoals());
        gameJson.setPenaltyResult(penaltyGoals);
        GameResultJson overtimeGoals = JsonBuilder.toJson(game.getOverTimeGoals());
        gameJson.setOvertimeResult(overtimeGoals);
        gameJson.setHomeTeam(JsonBuilder.toJson(game.getHomeTeam()));
        gameJson.setGuestTeam(JsonBuilder.toJson(game.getGuestTeam()));
        return gameJson;
    }

    public List<GameJson> map(List<Game> games) {
        return games.stream().map((? super T game) -> {
            GameJson json = new GameJson();
            json = this.map((Game)game, json);
            return json;
        }).collect(Collectors.toList());
    }
}

