/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web;

import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.BetofficeBasicJsonService;
import de.betoffice.web.JsonAssembler;
import de.betoffice.web.JsonBuilder;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GroupTeamTableJson;
import de.betoffice.web.json.GroupTypeJson;
import de.betoffice.web.json.RoundAndTableJson;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.SecurityTokenJson;
import de.betoffice.web.json.SubmitTippGameJson;
import de.betoffice.web.json.SubmitTippRoundJson;
import de.betoffice.web.json.TeamJson;
import de.betoffice.web.json.TeamResultJson;
import de.betoffice.web.json.UserJson;
import de.betoffice.web.json.UserTableJson;
import de.betoffice.web.misc.DateTimeUtils;
import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.DateTimeProvider;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.service.SecurityToken;
import de.winkler.betoffice.service.TippDto;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Session;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="betofficeBasicService")
public class DefaultBetofficeBasicJsonService
implements BetofficeBasicJsonService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBetofficeBasicJsonService.class);
    @Autowired
    private DateTimeProvider dateTimeProvider;
    private SeasonManagerService seasonManagerService;
    private MasterDataManagerService masterDataManagerService;
    private TippService tippService;
    private AuthService authService;

    @Autowired
    public void setSeasonManagerService(SeasonManagerService _seasonManagerService) {
        this.seasonManagerService = _seasonManagerService;
    }

    @Autowired
    public void setMasterDataManagerService(MasterDataManagerService _masterDataManagerService) {
        this.masterDataManagerService = _masterDataManagerService;
    }

    @Autowired
    public void setTippService(TippService _tippService) {
        this.tippService = _tippService;
    }

    @Autowired
    public void setAuthService(AuthService _authService) {
        this.authService = _authService;
    }

    @Override
    public SeasonJson findSeasonById(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        List rounds = this.seasonManagerService.findRounds(season);
        GameList nextTippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        JsonAssembler jsonAssembler = new JsonAssembler();
        SeasonJson seasonJson = jsonAssembler.build(season).rounds(rounds).currentRound(nextTippRound).assemble();
        return seasonJson;
    }

    @Override
    public List<GroupTypeJson> findAllGroups(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        List groupTypes = this.seasonManagerService.findGroupTypesBySeason(season);
        return JsonBuilder.toJsonWithGroupTypes(groupTypes);
    }

    @Override
    public SeasonJson findAllRounds(Long seasonId, Long groupTypeId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeId.longValue());
        Group group = this.seasonManagerService.findGroup(season, groupType);
        List rounds = this.seasonManagerService.findRounds(group);
        GameList nextTippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        JsonAssembler jsonAssembler = new JsonAssembler();
        SeasonJson seasonJson = jsonAssembler.build(season).rounds(rounds).currentRound(nextTippRound).assemble();
        return seasonJson;
    }

    @Override
    public RoundJson findRound(Long roundId) {
        GameList gameList = this.seasonManagerService.findRound(roundId.longValue());
        RoundJson roundJson = null;
        if (gameList != null) {
            Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build(gameList).games().lastRound(!nextRound.isPresent()).assemble();
        }
        return roundJson;
    }

    @Override
    public RoundJson findRound(Long roundId, Long groupTypeId) {
        GameList gameList = this.seasonManagerService.findRound(roundId.longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeId.longValue());
        Group group = this.seasonManagerService.findGroup(gameList.getSeason(), groupType);
        RoundJson roundJson = null;
        if (gameList != null) {
            Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build(gameList).games(gameList.toList(group)).lastRound(!nextRound.isPresent()).assemble();
        }
        return roundJson;
    }

    @Override
    public RoundJson findNextRound(Long roundId) {
        Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
        RoundJson roundJson = null;
        if (nextRound.isPresent()) {
            Optional nextNextRound = this.seasonManagerService.findNextRound(((GameList)nextRound.get()).getId().longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build((GameList)nextRound.get()).lastRound(!nextNextRound.isPresent()).games().assemble();
        }
        return roundJson;
    }

    @Override
    public RoundJson findPrevRound(Long roundId) {
        Optional prevRound = this.seasonManagerService.findPrevRound(roundId.longValue());
        RoundJson roundJson = null;
        if (prevRound.isPresent()) {
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build((GameList)prevRound.get()).lastRound(false).games().assemble();
        }
        return roundJson;
    }

    @Override
    public RoundAndTableJson findRoundTable(Long roundId, Long groupTypeId) {
        RoundJson roundJson = this.findRound(roundId, groupTypeId);
        Season season = this.seasonManagerService.findSeasonById(roundJson.getSeasonId().longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeId.longValue());
        RoundAndTableJson roundAndTableJson = new RoundAndTableJson();
        roundAndTableJson.setRoundJson(roundJson);
        List teamRanking = this.seasonManagerService.calculateTeamRanking(season, groupType, 0, roundJson.getIndex() - 1);
        GroupTeamTableJson groupTeamTableJson = new GroupTeamTableJson();
        groupTeamTableJson.setGroupTypeJson(JsonBuilder.toJson(groupType));
        for (TeamResult teamResult : teamRanking) {
            TeamResultJson teamResultJson = JsonBuilder.toJson(teamResult);
            groupTeamTableJson.add(teamResultJson);
        }
        roundAndTableJson.setGroupTeamTableJson(groupTeamTableJson);
        return roundAndTableJson;
    }

    @Override
    public RoundAndTableJson findNextRoundTable(Long roundId) {
        return this.findRoundTable(roundId, null);
    }

    @Override
    public RoundAndTableJson findPrevRoundTable(Long roundId) {
        return this.findRoundTable(roundId, null);
    }

    @Override
    public GameJson findGame(Long gameId) {
        Game game = this.seasonManagerService.findMatch(gameId);
        return JsonBuilder.toJson(game);
    }

    @Override
    public RoundJson findTipp(Long roundId, String nickName) {
        Optional user = this.masterDataManagerService.findUserByNickname(nickName);
        if (!user.isPresent()) {
            return null;
        }
        GameList round = this.seasonManagerService.findRound(roundId.longValue());
        List roundTipps = this.tippService.findTippsByRoundAndUser(round, (User)user.get());
        Optional nextNextRound = this.seasonManagerService.findNextRound(roundId.longValue());
        JsonAssembler jsonAssembler = new JsonAssembler();
        RoundJson roundJson = null;
        roundJson = roundTipps.isEmpty() ? jsonAssembler.build(round).lastRound(!nextNextRound.isPresent()).games().emptyTipp().assemble() : jsonAssembler.build(round).lastRound(!nextNextRound.isPresent()).games().tipps(roundTipps).assemble();
        return roundJson;
    }

    @Override
    public RoundJson findCurrentTipp(Long seasonId, String nickName) {
        GameList tippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        if (tippRound != null) {
            return this.findTipp(tippRound.getId(), nickName);
        }
        return null;
    }

    @Override
    public RoundJson findCurrent(Long seasonId) {
        GameList tippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        if (tippRound != null) {
            return JsonBuilder.toJson(tippRound);
        }
        return null;
    }

    @Override
    public RoundJson findNextTipp(Long roundId, String nickName) {
        Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
        if (nextRound.isPresent()) {
            return this.findTipp(((GameList)nextRound.get()).getId(), nickName);
        }
        return null;
    }

    @Override
    public RoundJson findPrevTipp(Long roundId, String nickName) {
        Optional prevRound = this.seasonManagerService.findPrevRound(roundId.longValue());
        if (prevRound.isPresent()) {
            return this.findTipp(((GameList)prevRound.get()).getId(), nickName);
        }
        return null;
    }

    @Override
    public RoundJson findTippRound(Long seasonId) {
        GameList tippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        RoundJson roundJson = null;
        if (tippRound != null) {
            roundJson = JsonBuilder.toJson(tippRound);
            List<GameJson> gameJson = JsonBuilder.toJsonWithGames(tippRound.unmodifiableList());
            roundJson.getGames().addAll(gameJson);
            roundJson.setTippable(this.isFinished(roundJson));
        }
        return roundJson;
    }

    @Override
    public UserTableJson calcUserRanking(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GameList round = this.tippService.findPreviousTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        UserTableJson userTableJson = new UserTableJson();
        if (round == null) {
            Optional lastRound = this.seasonManagerService.findFirstRound(season);
            round = (GameList)lastRound.get();
        }
        userTableJson.setRound(JsonBuilder.toJson(round));
        return this.calcUserRanking(userTableJson, round, 0);
    }

    @Override
    public UserTableJson calcUserRankingByRoundOnly(Long roundId) {
        Optional round = this.seasonManagerService.findRoundGameAndTipp(roundId.longValue());
        if (round.isPresent()) {
            UserTableJson userTableJson = new UserTableJson();
            userTableJson.setRound(JsonBuilder.toJson((GameList)round.get()));
            List<GameJson> jsonWithGamesAndTipps = JsonBuilder.toJsonWithGamesAndTipps(((GameList)round.get()).unmodifiableList());
            userTableJson.getRound().setGames(jsonWithGamesAndTipps);
            return this.calcUserRanking(userTableJson, (GameList)round.get(), ((GameList)round.get()).getIndex());
        }
        return null;
    }

    @Override
    public UserTableJson calcUserRankingByRound(Long roundId) {
        Optional round = this.seasonManagerService.findRoundGameAndTipp(roundId.longValue());
        UserTableJson userTableJson = new UserTableJson();
        userTableJson.setRound(JsonBuilder.toJson((GameList)round.get()));
        List<GameJson> jsonWithGamesAndTipps = JsonBuilder.toJsonWithGamesAndTipps(((GameList)round.get()).unmodifiableList());
        userTableJson.getRound().setGames(jsonWithGamesAndTipps);
        return this.calcUserRanking(userTableJson, (GameList)round.get(), 0);
    }

    private UserTableJson calcUserRanking(UserTableJson userTableJson, GameList round, int startIndex) {
        List userRanking = this.seasonManagerService.calculateUserRanking(round.getSeason(), startIndex, round.getIndex());
        for (UserResult ur : userRanking) {
            UserJson userJson = JsonBuilder.toJson(ur);
            userTableJson.addUser(userJson);
        }
        SeasonJson season = JsonBuilder.toJson(round.getSeason());
        userTableJson.setSeason(season);
        this.findNextAndPrevRound(round, userTableJson);
        return userTableJson;
    }

    private void findNextAndPrevRound(GameList round, UserTableJson userTableJson) {
        Optional nextNextRound = this.seasonManagerService.findNextRound(round.getId().longValue());
        userTableJson.getRound().setLastRound(!nextNextRound.isPresent());
        userTableJson.getRound().setTippable(this.isFinished(userTableJson.getRound()));
    }

    @Override
    public UserTableJson calcUserRankingByNextRound(Long roundId) {
        Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
        if (nextRound.isPresent()) {
            return this.calcUserRankingByRound(((GameList)nextRound.get()).getId());
        }
        return null;
    }

    @Override
    public UserTableJson calcUserRankingByPrevRound(Long roundId) {
        Optional prevRound = this.seasonManagerService.findPrevRound(roundId.longValue());
        if (prevRound.isPresent()) {
            return this.calcUserRankingByRound(((GameList)prevRound.get()).getId());
        }
        return null;
    }

    @Override
    public List<TeamJson> findAllTeams() {
        List teams = this.masterDataManagerService.findAllTeams();
        return JsonBuilder.toJsonWithTeams(teams);
    }

    @Override
    public List<SeasonJson> findAllSeason() {
        List seasons = this.seasonManagerService.findAllSeasons();
        return JsonBuilder.toJsonWithSeasons(seasons);
    }

    @Override
    public SecurityTokenJson login(String user, String password, String sessionId, String address, String browserId) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Try to login: {}", (Object)user);
        }
        SecurityToken securityToken = this.authService.login(user, password, sessionId, address, browserId);
        SecurityTokenJson stj = null;
        if (securityToken == null) {
            stj = new SecurityTokenJson();
            stj.setLoginTime(DateTimeUtils.toDateTime(this.dateTimeProvider.currentDateTime()));
            stj.setNickname(user);
            stj.setRole("no_authorization");
            stj.setToken("no_authorization");
        } else {
            stj = JsonBuilder.toJson(securityToken);
            if (LOG.isInfoEnabled()) {
                LOG.info("Login successful: user=[{}], token=[{}]", (Object)user, (Object)stj);
            }
        }
        return stj;
    }

    @Override
    public SecurityTokenJson logout(String nickname, String token) {
        Optional user = this.masterDataManagerService.findUserByNickname(nickname);
        SecurityToken securityToken = new SecurityToken(token, (User)user.get(), null, this.dateTimeProvider.currentDateTime());
        this.authService.logout(securityToken);
        return JsonBuilder.toJson(securityToken);
    }

    @Override
    public RoundJson submitTipp(String token, SubmitTippRoundJson tippRoundJson) throws AccessDeniedException {
        Optional session = this.authService.validateSession(token);
        if (!session.isPresent()) {
            throw new AccessDeniedException();
        }
        if (!StringUtils.equals((CharSequence)((Session)session.get()).getUser().getNickName(), (CharSequence)tippRoundJson.getNickname())) {
            throw new AccessDeniedException();
        }
        TippDto tippDto = new TippDto();
        tippDto.setNickname(tippRoundJson.getNickname());
        tippDto.setRoundId(tippRoundJson.getRoundId());
        tippDto.setToken(token);
        tippDto.setSubmitTime(this.dateTimeProvider.currentDateTime());
        for (SubmitTippGameJson submitTippJson : tippRoundJson.getSubmitTippGames()) {
            TippDto.GameTippDto gameTippDto = new TippDto.GameTippDto();
            gameTippDto.setGameId(submitTippJson.getGameId());
            gameTippDto.setHomeGoals(submitTippJson.getTippResult().getHomeGoals());
            gameTippDto.setGuestGoals(submitTippJson.getTippResult().getGuestGoals());
            tippDto.addGameTipp(gameTippDto);
        }
        this.tippService.addTipp(tippDto);
        return this.findTipp(tippRoundJson.getRoundId(), tippRoundJson.getNickname());
    }

    private boolean isFinished(RoundJson round) {
        boolean finished = false;
        for (GameJson game : round.getGames()) {
            if (game.isFinished()) continue;
            finished = true;
        }
        return finished;
    }
}

