/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.web.json.SeasonJson;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.enums.SeasonType;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.List;
import java.util.stream.Collectors;

public class SeasonJsonMapper {
    public SeasonJson map(Season season, SeasonJson seasonJson) {
        seasonJson.setId(season.getId());
        seasonJson.setName(season.getName());
        seasonJson.setYear(season.getYear());
        seasonJson.setSeasonType(season.getMode().toString());
        seasonJson.setTeamType(season.getTeamType().toString());
        if (season.getChampionshipConfiguration() != null) {
            seasonJson.setOpenligaLeagueSeason(season.getChampionshipConfiguration().getOpenligaLeagueSeason());
            seasonJson.setOpenligaLeagueShortcut(season.getChampionshipConfiguration().getOpenligaLeagueShortcut());
        }
        return seasonJson;
    }

    public List<SeasonJson> map(List<Season> seasons) {
        return seasons.stream().map((? super T season) -> {
            SeasonJson json = new SeasonJson();
            json = this.map((Season)season, json);
            return json;
        }).collect(Collectors.toList());
    }

    public Season reverse(SeasonJson seasonJson, Season season) {
        season.setMode(SeasonType.valueOf((String)seasonJson.getSeasonType()));
        season.setTeamType(TeamType.valueOf((String)seasonJson.getTeamType()));
        season.setYear(seasonJson.getYear());
        season.setName(seasonJson.getName());
        season.getChampionshipConfiguration().setOpenligaLeagueSeason(seasonJson.getOpenligaLeagueSeason());
        season.getChampionshipConfiguration().setOpenligaLeagueShortcut(seasonJson.getOpenligaLeagueShortcut());
        return season;
    }
}

