/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web;

import de.betoffice.service.OpenligadbUpdateService;
import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.BetofficeAdminJsonService;
import de.betoffice.web.JsonBuilder;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.PartyJson;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.SeasonMemberJson;
import de.betoffice.web.json.TeamJson;
import de.betoffice.web.json.builder.PartyJsonMapper;
import de.betoffice.web.json.builder.SeasonJsonMapper;
import de.betoffice.web.json.builder.SeasonMemberJsonMapper;
import de.betoffice.web.json.builder.TeamJsonMapper;
import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Session;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="betofficeAdminService")
public class DefaultBetofficeAdminJsonService
implements BetofficeAdminJsonService {
    private OpenligadbUpdateService openligadbUpdateService;
    private MasterDataManagerService masterDataManagerService;
    private SeasonManagerService seasonManagerService;
    private AuthService authService;

    @Autowired
    public void setOpenligadbUpdateService(OpenligadbUpdateService openligadbUpdateService) {
        this.openligadbUpdateService = openligadbUpdateService;
    }

    @Autowired
    public void setMasterDataManagerService(MasterDataManagerService _masterDataManagerService) {
        this.masterDataManagerService = _masterDataManagerService;
    }

    @Autowired
    public void setSeasonManagerService(SeasonManagerService _seasonManagerService) {
        this.seasonManagerService = _seasonManagerService;
    }

    @Autowired
    public void setAuthService(AuthService _authService) {
        this.authService = _authService;
    }

    @Override
    public void validateAdminSession(String token) {
        Optional session = this.authService.validateSession(token);
        if (!session.isPresent()) {
            throw new AccessDeniedException();
        }
        if (((Session)session.get()).getLogout() != null) {
            throw new AccessDeniedException();
        }
        Date loginDate = ((Session)session.get()).getLogin();
        DateTime dateTime = new DateTime(loginDate.getTime());
        if (dateTime.isBefore((ReadableInstant)DateTime.now().minusDays(1))) {
            throw new AccessDeniedException();
        }
        if (!((Session)session.get()).getUser().isAdmin()) {
            throw new AccessDeniedException();
        }
    }

    @Override
    public RoundJson reconcileRoundWithOpenligadb(String token, Long roundId) {
        GameList gameList = this.seasonManagerService.findRound(roundId.longValue());
        this.openligadbUpdateService.createOrUpdateRound(gameList.getSeason().getId().longValue(), gameList.getIndex());
        GameList updatedGameList = this.seasonManagerService.findRound(roundId.longValue());
        return JsonBuilder.toJsonWithGames(updatedGameList);
    }

    @Override
    public RoundJson mountRoundWithOpenligadb(String token, Long roundId) {
        GameList round = this.seasonManagerService.findRound(roundId.longValue());
        if (round != null) {
            this.openligadbUpdateService.createOrUpdateRound(round.getSeason().getId().longValue(), round.getIndex() + 1);
        }
        Optional updatedGameList = this.seasonManagerService.findNextRound(roundId.longValue());
        return JsonBuilder.toJsonWithGames((GameList)updatedGameList.get());
    }

    @Override
    public TeamJson findTeam(long teamId) {
        Team team = this.masterDataManagerService.findTeamById(teamId);
        return new TeamJsonMapper().map(team, new TeamJson());
    }

    @Override
    public List<TeamJson> findTeams() {
        return new TeamJsonMapper().map(this.masterDataManagerService.findAllTeams());
    }

    @Override
    public TeamJson addTeam(TeamJson teamJson) {
        TeamJsonMapper mapper = new TeamJsonMapper();
        Team team = new TeamJsonMapper().reverse(teamJson, new Team());
        this.masterDataManagerService.createTeam(team);
        return mapper.map(team, teamJson);
    }

    @Override
    public TeamJson updateTeam(TeamJson teamJson) {
        Team storedTeam = this.masterDataManagerService.findTeamById(teamJson.getId().longValue());
        Team team = new TeamJsonMapper().reverse(teamJson, storedTeam);
        this.masterDataManagerService.updateTeam(team);
        return teamJson;
    }

    @Override
    public PartyJson findUser(long userId) {
        User user = this.masterDataManagerService.findUser(userId);
        return new PartyJsonMapper().map(user, new PartyJson());
    }

    @Override
    public List<PartyJson> findUsers() {
        return new PartyJsonMapper().map(this.masterDataManagerService.findAllUsers());
    }

    @Override
    public PartyJson addUser(PartyJson partyJson) {
        PartyJsonMapper mapper = new PartyJsonMapper();
        User user = mapper.reverse(partyJson, new User());
        user = this.masterDataManagerService.createUser(user);
        return mapper.map(user, partyJson);
    }

    @Override
    public PartyJson updateUser(PartyJson partyJson) {
        User storedUser = this.masterDataManagerService.findUser(partyJson.getId().longValue());
        User user = new PartyJsonMapper().reverse(partyJson, storedUser);
        this.masterDataManagerService.updateUser(user);
        return partyJson;
    }

    @Override
    public SeasonJson addSeason(SeasonJson seasonJson) {
        Season season = new SeasonJsonMapper().reverse(seasonJson, new Season());
        this.masterDataManagerService.createSeason(season);
        return seasonJson;
    }

    @Override
    public SeasonJson updateSeason(SeasonJson seasonJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        season = new SeasonJsonMapper().reverse(seasonJson, season);
        this.masterDataManagerService.updateSeason(season);
        return new SeasonJsonMapper().map(season, seasonJson);
    }

    @Override
    public void updateRound(RoundJson roundJson) {
        GameList round = this.seasonManagerService.findRound(roundJson.getId().longValue());
        ArrayList<Game> games = new ArrayList<Game>();
        for (GameJson match : roundJson.getGames()) {
            Game game = round.getById(match.getId().longValue());
            this.updateGame(match, game);
            games.add(game);
        }
        this.seasonManagerService.updateMatch(games);
    }

    @Override
    public void updateGame(GameJson gameJson) {
        Game game = this.seasonManagerService.findMatch(gameJson.getId());
        game.setDateTime(gameJson.getDateTime());
        this.updateGame(gameJson, game);
        this.seasonManagerService.updateMatch(game);
    }

    private void updateGame(GameJson match, Game game) {
        game.setPlayed(match.isFinished());
        game.setKo(match.isKo());
        game.setResult(match.getResult().getHomeGoals(), match.getResult().getGuestGoals());
        game.setHalfTimeGoals(match.getHalfTimeResult().getHomeGoals(), match.getHalfTimeResult().getGuestGoals());
        game.setOverTimeGoals(match.getOvertimeResult().getHomeGoals(), match.getOvertimeResult().getGuestGoals());
        game.setPenaltyGoals(match.getPenaltyResult().getHomeGoals(), match.getPenaltyResult().getGuestGoals());
    }

    @Override
    public List<SeasonMemberJson> findPotentialSeasonMembers(long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        List activatedUsers = this.seasonManagerService.findActivatedUsers(season);
        List users = this.masterDataManagerService.findAllUsers();
        users.removeAll(activatedUsers);
        SeasonMemberJsonMapper mapper = new SeasonMemberJsonMapper();
        List<SeasonMemberJson> seasonMembers = mapper.map(users);
        return seasonMembers;
    }

    @Override
    public List<SeasonMemberJson> findAllSeasonMembers(long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        List activatedUsers = this.seasonManagerService.findActivatedUsers(season);
        SeasonMemberJsonMapper mapper = new SeasonMemberJsonMapper();
        List<SeasonMemberJson> seasonMembers = mapper.map(activatedUsers);
        return seasonMembers;
    }

    @Override
    public List<SeasonMemberJson> addSeasonMembers(long seasonId, List<SeasonMemberJson> seasonMembers) {
        List<User> users = this.findUsers(seasonMembers);
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        this.seasonManagerService.addUsers(season, users);
        return this.findAllSeasonMembers(seasonId);
    }

    @Override
    public List<SeasonMemberJson> removeSeasonMembers(long seasonId, List<SeasonMemberJson> seasonMembers) {
        List<User> users = this.findUsers(seasonMembers);
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        this.seasonManagerService.removeUsers(season, users);
        return this.findAllSeasonMembers(seasonId);
    }

    private List<User> findUsers(List<SeasonMemberJson> seasonMembers) {
        ArrayList<User> users = new ArrayList<User>();
        for (SeasonMemberJson member : seasonMembers) {
            User user = this.masterDataManagerService.findUser(member.getId().longValue());
            users.add(user);
        }
        return users;
    }
}

