/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.admin;

import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.admin.AdminService;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GroupTypeJson;
import de.betoffice.web.json.IGameJson;
import de.betoffice.web.json.PartyJson;
import de.betoffice.web.json.RoundAndTableJson;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonGroupTeamJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.SeasonMemberJson;
import de.betoffice.web.json.TeamJson;
import de.betoffice.web.season.BetofficeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/chiefoperator"})
public class AdministrationController {
    private BetofficeService betofficeBasicJsonService;
    private AdminService betofficeAdminJsonService;

    @Autowired
    public void setBetofficeBasicJsonService(BetofficeService _betofficeBasicJsonService) {
        this.betofficeBasicJsonService = _betofficeBasicJsonService;
    }

    @Autowired
    public void setBetofficeAdminJsonService(AdminService _betofficeAdminJsonService) {
        this.betofficeAdminJsonService = _betofficeAdminJsonService;
    }

    @RequestMapping(value={"/season/{seasonId}/round/{roundId}/group/{groupId}/ligadbupdate"}, method={RequestMethod.POST}, headers={"Content-type=application/json"})
    public RoundAndTableJson updateRoundByOpenligaDb(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId, @PathVariable(value="groupId") Long groupId, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        this.betofficeAdminJsonService.reconcileRoundWithOpenligadb(token, seasonId, roundId);
        return this.betofficeBasicJsonService.findRoundTable(seasonId, roundId, groupId);
    }

    @RequestMapping(value={"/season/{seasonId}/round/{roundId}/group/{groupId}/ligadbcreate"}, method={RequestMethod.POST}, headers={"Content-type=application/json"})
    public RoundAndTableJson createOrUpdateRoundByOpenligaDb(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId, @PathVariable(value="groupId") Long groupId, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        this.betofficeAdminJsonService.mountRoundWithOpenligadb(token, seasonId, roundId);
        return this.betofficeBasicJsonService.findRoundTable(seasonId, roundId, groupId);
    }

    @RequestMapping(value={"/season/{seasonId}/round/{roundId}/group/{groupId}/update"}, method={RequestMethod.POST}, headers={"Content-type=application/json"})
    public RoundAndTableJson updateRound(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId, @PathVariable(value="groupId") Long groupId, @RequestBody RoundJson roundJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        this.betofficeAdminJsonService.updateRound(roundJson);
        return this.betofficeBasicJsonService.findRoundTable(seasonId, roundId, groupId);
    }

    @RequestMapping(value={"/game/update"}, method={RequestMethod.POST}, headers={"Content-type=application/json"})
    public IGameJson updateGame(@RequestBody GameJson gameJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        this.betofficeAdminJsonService.updateGame(gameJson);
        return this.betofficeBasicJsonService.findGame(gameJson.getId());
    }

    @CrossOrigin
    @RequestMapping(value={"/season/{seasonId}"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public SeasonJson findSeason(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeBasicJsonService.findSeasonById(seasonId);
    }

    @CrossOrigin
    @RequestMapping(value={"/season"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public List<SeasonJson> findSeasons() {
        return this.betofficeBasicJsonService.findAllSeason();
    }

    @CrossOrigin
    @RequestMapping(value={"/season"}, method={RequestMethod.POST}, headers={"Content-type=application/json"})
    public SeasonJson addSeason(@RequestBody SeasonJson season, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.addSeason(season);
    }

    @CrossOrigin
    @RequestMapping(value={"/season"}, method={RequestMethod.PUT}, headers={"Content-type=application/json"})
    public SeasonJson updateSeason(@RequestBody SeasonJson season, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.updateSeason(season);
    }

    @CrossOrigin
    @PostMapping(value={"/season/{seasonId}/group"})
    public SeasonJson addGroupToSeason(@PathVariable(value="seasonId") Long seasonId, @RequestBody GroupTypeJson groupTypeJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        SeasonJson seasonJson = this.betofficeBasicJsonService.findSeasonById(seasonId);
        this.betofficeAdminJsonService.addGroupToSeason(seasonJson, groupTypeJson);
        return seasonJson;
    }

    @CrossOrigin
    @DeleteMapping(value={"/season/{seasonId}/group/{groupTypeId}"})
    public SeasonJson removeGroupFromSeason(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="groupTypeId") Long groupTypeId, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        SeasonJson seasonJson = this.betofficeBasicJsonService.findSeasonById(seasonId);
        GroupTypeJson groupTypeJson = this.betofficeAdminJsonService.findGroupType(groupTypeId);
        this.betofficeAdminJsonService.removeGroupFromSeason(seasonJson, groupTypeJson);
        return seasonJson;
    }

    @CrossOrigin
    @GetMapping(value={"/season/{seasonId}/groupteam"})
    public SeasonGroupTeamJson findGroupWithTeams(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeAdminJsonService.findSeasonGroupsAndTeams(seasonId);
    }

    @CrossOrigin
    @GetMapping(value={"/season/{seasonId}/groupteam/{groupTypeId}/candidates"})
    public List<TeamJson> findTeamsForAdding(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="groupTypeId") Long groupTypeId) {
        SeasonJson seasonJson = this.betofficeBasicJsonService.findSeasonById(seasonId);
        GroupTypeJson groupTypeJson = this.betofficeAdminJsonService.findGroupType(groupTypeId);
        return this.betofficeAdminJsonService.findSeasonGroupAndTeamCandidates(seasonJson, groupTypeJson);
    }

    @CrossOrigin
    @PostMapping(value={"/season/{seasonId}/groupteam/{groupTypeId}"})
    public SeasonJson addTeamToGroup(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="groupTypeId") Long groupTypeId, @RequestBody TeamJson teamJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        SeasonJson seasonJson = this.betofficeBasicJsonService.findSeasonById(seasonId);
        GroupTypeJson groupTypeJson = this.betofficeAdminJsonService.findGroupType(groupTypeId);
        this.betofficeAdminJsonService.addTeamToGroup(seasonJson, groupTypeJson, teamJson);
        return seasonJson;
    }

    @CrossOrigin
    @DeleteMapping(value={"/season/{seasonId}/groupteam/{groupTypeId}/team/{teamId}"})
    public SeasonJson removeTeamFromGroup(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="groupTypeId") Long groupTypeId, @PathVariable(value="teamId") Long teamId, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        SeasonJson seasonJson = this.betofficeBasicJsonService.findSeasonById(seasonId);
        GroupTypeJson groupTypeJson = this.betofficeAdminJsonService.findGroupType(groupTypeId);
        TeamJson teamJson = this.betofficeAdminJsonService.findTeam(teamId);
        this.betofficeAdminJsonService.removeTeamFromGroup(seasonJson, groupTypeJson, teamJson);
        return seasonJson;
    }

    @GetMapping(value={"/user/{userId}"}, headers={"Content-type=application/json"})
    public PartyJson findUser(@PathVariable(value="userId") Long userId) {
        return this.betofficeAdminJsonService.findUser(userId);
    }

    @GetMapping(value={"/user"}, headers={"Content-type=application/json"})
    public List<PartyJson> findUsers() {
        return this.betofficeAdminJsonService.findUsers();
    }

    @PostMapping(value={"/user/add"}, headers={"Content-type=application/json"})
    public PartyJson addUser(@RequestBody PartyJson partyJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.addUser(partyJson);
    }

    @PostMapping(value={"/user/update"}, headers={"Content-type=application/json"})
    public PartyJson updateUser(@RequestBody PartyJson partyJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.updateUser(partyJson);
    }

    @RequestMapping(value={"/team/{teamId}"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public TeamJson findTeam(@PathVariable(value="teamId") Long teamId) {
        return this.betofficeAdminJsonService.findTeam(teamId);
    }

    @RequestMapping(value={"/team"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public List<TeamJson> findTeams() {
        return this.betofficeAdminJsonService.findTeams();
    }

    @PostMapping(value={"/team"}, headers={"Content-type=application/json"})
    public TeamJson addTeam(@RequestBody TeamJson teamJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.addTeam(teamJson);
    }

    @PutMapping(value={"/team"}, headers={"Content-type=application/json"})
    public TeamJson updateTeam(@RequestBody TeamJson teamJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.updateTeam(teamJson);
    }

    @RequestMapping(value={"/groupType"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public List<GroupTypeJson> listGroupTypes() {
        return this.betofficeAdminJsonService.findGroupTypes();
    }

    @RequestMapping(value={"/season/{seasonId}/potentialuser"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public List<SeasonMemberJson> listPotentialUsers(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeAdminJsonService.findPotentialSeasonMembers(seasonId);
    }

    @GetMapping(value={"/season/{seasonId}/user"}, headers={"Content-type=application/json"})
    public List<SeasonMemberJson> listUsers(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeAdminJsonService.findAllSeasonMembers(seasonId);
    }

    @PostMapping(value={"/season/{seasonId}/user/add"}, headers={"Content-type=application/json"})
    public List<SeasonMemberJson> addUsers(@PathVariable(value="seasonId") Long seasonId, @RequestBody List<SeasonMemberJson> members, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.addSeasonMembers(seasonId, members);
    }

    @PostMapping(value={"/season/{seasonId}/user/remove"}, headers={"Content-type=application/json"})
    public List<SeasonMemberJson> removeUsers(@PathVariable(value="seasonId") Long seasonId, @RequestBody List<SeasonMemberJson> members, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        this.betofficeAdminJsonService.validateAdminSession(token);
        return this.betofficeAdminJsonService.removeSeasonMembers(seasonId, members);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Access denied")
    @ExceptionHandler(value={AccessDeniedException.class})
    public void forbidden() {
    }
}

