/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.admin;

import de.betoffice.openligadb.OpenligadbUpdateService;
import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.admin.AdminService;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GroupTeamJson;
import de.betoffice.web.json.GroupTypeJson;
import de.betoffice.web.json.IGameJson;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.PartyJson;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonGroupTeamJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.SeasonMemberJson;
import de.betoffice.web.json.TeamJson;
import de.betoffice.web.json.builder.GroupTypeJsonMapper;
import de.betoffice.web.json.builder.PartyJsonMapper;
import de.betoffice.web.json.builder.SeasonJsonMapper;
import de.betoffice.web.json.builder.SeasonMemberJsonMapper;
import de.betoffice.web.json.builder.TeamJsonMapper;
import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.service.DateTimeProvider;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.CommunityReference;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.Session;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.User;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdminService
implements AdminService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAdminService.class);
    @Autowired
    private DateTimeProvider dateTimeProvider;
    @Autowired
    private OpenligadbUpdateService openligadbUpdateService;
    @Autowired
    private MasterDataManagerService masterDataManagerService;
    @Autowired
    private SeasonManagerService seasonManagerService;
    @Autowired
    private CommunityService communityService;
    @Autowired
    private AuthService authService;

    @Override
    public void validateAdminSession(String token) {
        Optional session = this.authService.validateSession(token);
        if (!session.isPresent()) {
            throw new AccessDeniedException();
        }
        if (((Session)session.get()).getLogout() != null) {
            throw new AccessDeniedException();
        }
        ZonedDateTime loginDate = ((Session)session.get()).getLogin();
        if (loginDate.isBefore(ZonedDateTime.now(this.dateTimeProvider.defaultZoneId()).minusDays(3L))) {
            throw new AccessDeniedException();
        }
        if (!((Session)session.get()).getUser().isAdmin()) {
            throw new AccessDeniedException();
        }
    }

    @Override
    public RoundJson reconcileRoundWithOpenligadb(String token, Long seasonId, Long roundId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GameList round = this.seasonManagerService.findRound(roundId.longValue());
        if (round == null) {
            this.openligadbUpdateService.createOrUpdateRound(seasonId.longValue(), 0);
        } else {
            this.openligadbUpdateService.createOrUpdateRound(round.getSeason().getId().longValue(), round.getIndex());
        }
        GameList updatedGameList = this.seasonManagerService.findNextRound(roundId.longValue()).orElseGet(() -> (GameList)this.seasonManagerService.findFirstRound(season).orElseThrow());
        return JsonBuilder.toJsonWithGames((GameList)this.seasonManagerService.findRoundGames(updatedGameList.getId().longValue()).get());
    }

    @Override
    public RoundJson mountRoundWithOpenligadb(String token, Long seasonId, Long roundId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GameList round = this.seasonManagerService.findRound(roundId.longValue());
        if (round == null) {
            this.openligadbUpdateService.createOrUpdateRound(seasonId.longValue(), 0);
        } else {
            this.openligadbUpdateService.createOrUpdateRound(seasonId.longValue(), round.getIndex() + 1);
        }
        GameList updatedGameList = this.seasonManagerService.findNextRound(roundId.longValue()).orElseGet(() -> (GameList)this.seasonManagerService.findFirstRound(season).orElseThrow());
        return JsonBuilder.toJsonWithGames((GameList)this.seasonManagerService.findRoundGames(updatedGameList.getId().longValue()).get());
    }

    @Override
    public TeamJson findTeam(long teamId) {
        Team team = this.masterDataManagerService.findTeamById(teamId);
        return TeamJsonMapper.map(team, new TeamJson());
    }

    @Override
    public List<TeamJson> findTeams() {
        return TeamJsonMapper.map(this.masterDataManagerService.findAllTeams());
    }

    @Override
    public TeamJson addTeam(TeamJson teamJson) {
        Team team = TeamJsonMapper.reverse(teamJson, new Team());
        this.masterDataManagerService.createTeam(team);
        return TeamJsonMapper.map(team, teamJson);
    }

    @Override
    public TeamJson updateTeam(TeamJson teamJson) {
        Team storedTeam = this.masterDataManagerService.findTeamById(teamJson.getId().longValue());
        Team team = TeamJsonMapper.reverse(teamJson, storedTeam);
        this.masterDataManagerService.updateTeam(team);
        return teamJson;
    }

    @Override
    public PartyJson findUser(long userId) {
        User user = this.communityService.findUser(userId);
        return PartyJsonMapper.map(user, new PartyJson());
    }

    @Override
    public List<PartyJson> findUsers() {
        return PartyJsonMapper.map(this.communityService.findAllUsers());
    }

    @Override
    public PartyJson addUser(PartyJson partyJson) {
        User user = PartyJsonMapper.reverse(partyJson, new User());
        user = this.communityService.createUser(user);
        return PartyJsonMapper.map(user, partyJson);
    }

    @Override
    public PartyJson updateUser(PartyJson partyJson) {
        User storedUser = this.communityService.findUser(partyJson.getId().longValue());
        User user = PartyJsonMapper.reverse(partyJson, storedUser);
        this.communityService.updateUser(user);
        return partyJson;
    }

    @Override
    public SeasonJson addSeason(SeasonJson seasonJson) {
        Season season = SeasonJsonMapper.reverse(seasonJson, new Season());
        this.masterDataManagerService.createSeason(season);
        return seasonJson;
    }

    @Override
    public SeasonJson updateSeason(SeasonJson seasonJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        season = SeasonJsonMapper.reverse(seasonJson, season);
        this.masterDataManagerService.updateSeason(season);
        return SeasonJsonMapper.map(season, seasonJson);
    }

    @Override
    public void updateRound(RoundJson roundJson) {
        Optional round = this.seasonManagerService.findRoundGames(roundJson.getId().longValue());
        if (round.isEmpty()) {
            LOG.error("Can\u00b4t find round with id={}.", (Object)roundJson.getId());
            return;
        }
        ArrayList<Game> games = new ArrayList<Game>();
        for (GameJson match : roundJson.getGames()) {
            Game game = ((GameList)round.get()).getById(match.getId().longValue());
            this.updateGame(match, game);
            games.add(game);
        }
        this.seasonManagerService.updateMatch(games);
    }

    @Override
    public void updateGame(GameJson gameJson) {
        Game game = this.seasonManagerService.findMatch(gameJson.getId());
        game.setDateTime(gameJson.getDateTime());
        this.updateGame(gameJson, game);
        this.seasonManagerService.updateMatch(game);
    }

    private void updateGame(IGameJson match, Game game) {
        game.setPlayed(match.isFinished());
        game.setKo(match.isKo());
        game.setResult(match.getResult().getHomeGoals(), match.getResult().getGuestGoals());
        game.setHalfTimeGoals(match.getHalfTimeResult().getHomeGoals(), match.getHalfTimeResult().getGuestGoals());
        game.setOverTimeGoals(match.getOvertimeResult().getHomeGoals(), match.getOvertimeResult().getGuestGoals());
        game.setPenaltyGoals(match.getPenaltyResult().getHomeGoals(), match.getPenaltyResult().getGuestGoals());
    }

    @Override
    public List<SeasonMemberJson> findPotentialSeasonMembers(long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        CommunityReference defaultPlayerGroup = CommunityService.defaultPlayerGroup((SeasonReference)season.getReference());
        Set activatedUsers = this.communityService.findMembers(defaultPlayerGroup);
        List users = this.communityService.findAllUsers();
        users.removeAll(activatedUsers);
        return SeasonMemberJsonMapper.map(users);
    }

    @Override
    public List<SeasonMemberJson> findAllSeasonMembers(long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        CommunityReference defaultPlayerGroup = CommunityService.defaultPlayerGroup((SeasonReference)season.getReference());
        Set activatedUsers = this.communityService.findMembers(defaultPlayerGroup);
        return SeasonMemberJsonMapper.map(activatedUsers);
    }

    @Override
    public List<SeasonMemberJson> addSeasonMembers(long seasonId, List<SeasonMemberJson> seasonMembers) {
        List<User> users = this.findUsers(seasonMembers);
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        CommunityReference defaultPlayerGroup = CommunityService.defaultPlayerGroup((SeasonReference)season.getReference());
        HashSet<Nickname> nicknames = new HashSet<Nickname>(users.stream().map(User::getNickname).toList());
        this.communityService.addMembers(defaultPlayerGroup, nicknames);
        return this.findAllSeasonMembers(seasonId);
    }

    @Override
    public List<SeasonMemberJson> removeSeasonMembers(long seasonId, List<SeasonMemberJson> seasonMembers) {
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        CommunityReference defaultPlayerGroup = CommunityService.defaultPlayerGroup((SeasonReference)season.getReference());
        HashSet<Nickname> nicknames = new HashSet<Nickname>(seasonMembers.stream().map(sm -> Nickname.of((String)sm.getNickname())).toList());
        this.communityService.removeMembers(defaultPlayerGroup, nicknames);
        return this.findAllSeasonMembers(seasonId);
    }

    private List<User> findUsers(List<SeasonMemberJson> seasonMembers) {
        ArrayList<User> users = new ArrayList<User>();
        for (SeasonMemberJson member : seasonMembers) {
            User user = this.communityService.findUser(member.getId().longValue());
            users.add(user);
        }
        return users;
    }

    @Override
    public List<GroupTypeJson> findGroupTypes() {
        return GroupTypeJsonMapper.map(this.masterDataManagerService.findAllGroupTypes());
    }

    @Override
    public GroupTypeJson findGroupType(long groupTypeId) {
        return GroupTypeJsonMapper.map(this.masterDataManagerService.findGroupType(groupTypeId), new GroupTypeJson());
    }

    @Override
    public SeasonJson addGroupToSeason(SeasonJson seasonJson, GroupTypeJson groupTypeJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeJson.getId().longValue());
        Season season2 = this.seasonManagerService.addGroupType(season, groupType);
        return SeasonJsonMapper.map(season2, new SeasonJson());
    }

    @Override
    public void removeGroupFromSeason(SeasonJson seasonJson, GroupTypeJson groupTypeJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeJson.getId().longValue());
        this.seasonManagerService.removeGroupType(season, groupType);
    }

    @Override
    public SeasonGroupTeamJson findSeasonGroupsAndTeams(long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId);
        List groups = this.seasonManagerService.findGroups(season);
        SeasonGroupTeamJson seasonGroupTeamJson = new SeasonGroupTeamJson();
        for (Group group : groups) {
            List teams = this.seasonManagerService.findTeams(group);
            GroupTeamJson groupTeamJson = new GroupTeamJson();
            groupTeamJson.setGroupType(GroupTypeJsonMapper.map(group.getGroupType(), new GroupTypeJson()));
            groupTeamJson.setTeams(TeamJsonMapper.map(teams));
            seasonGroupTeamJson.getGroupTeams().add(groupTeamJson);
        }
        return seasonGroupTeamJson;
    }

    @Override
    public List<TeamJson> findSeasonGroupAndTeamCandidates(SeasonJson seasonJson, GroupTypeJson groupTypeJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeJson.getId().longValue());
        List teams = this.seasonManagerService.findTeams(season, groupType);
        List teamCandidates = this.masterDataManagerService.findTeams(season.getTeamType());
        teamCandidates.removeAll(teams);
        return TeamJsonMapper.map(teamCandidates);
    }

    @Override
    public void addTeamToGroup(SeasonJson seasonJson, GroupTypeJson groupTypeJson, TeamJson teamJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeJson.getId().longValue());
        Team team = this.masterDataManagerService.findTeamById(teamJson.getId().longValue());
        this.seasonManagerService.addTeam(season, groupType, team);
    }

    @Override
    public void removeTeamFromGroup(SeasonJson seasonJson, GroupTypeJson groupTypeJson, TeamJson teamJson) {
        Season season = this.seasonManagerService.findSeasonById(seasonJson.getId().longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeJson.getId().longValue());
        Team team = this.masterDataManagerService.findTeamById(teamJson.getId().longValue());
        this.seasonManagerService.removeTeam(season, groupType, team);
    }
}

