/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.web.json.PartyJson;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.User;
import java.util.List;

public class PartyJsonMapper {
    public static PartyJson map(User user, PartyJson partyJson) {
        partyJson.setId(user.getId());
        partyJson.setName(user.getName());
        partyJson.setSurname(user.getSurname());
        partyJson.setMail(user.getEmail());
        partyJson.setNickname(user.getNickname().value());
        partyJson.setPassword(user.getPassword());
        partyJson.setPhone(user.getPhone());
        partyJson.setTitle(user.getTitle());
        return partyJson;
    }

    public static List<PartyJson> map(List<User> users) {
        return users.stream().map(PartyJsonMapper::map).toList();
    }

    private static PartyJson map(User user) {
        return PartyJsonMapper.map(user, new PartyJson());
    }

    public static User reverse(PartyJson partyJson, User user) {
        user.setName(partyJson.getName());
        user.setSurname(partyJson.getSurname());
        user.setEmail(partyJson.getMail());
        user.setNickname(Nickname.of((String)partyJson.getNickname()));
        user.setPassword(partyJson.getPassword());
        user.setPhone(partyJson.getPhone());
        user.setTitle(partyJson.getTitle());
        return user;
    }
}

