/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.research;

import de.betoffice.web.json.HistoryTeamVsTeamJson;
import de.betoffice.web.json.HistoryTeamVsTeamJsonMapper;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.TeamJson;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/research"})
public class ResearchDataServlet {
    private SeasonManagerService seasonManagerService;
    private MasterDataManagerService masterDataManagerService;

    @Autowired
    public void setSeasonManagerService(SeasonManagerService _seasonManagerService) {
        this.seasonManagerService = _seasonManagerService;
    }

    @Autowired
    public void setMasterDataManagerService(MasterDataManagerService _masterDataManagerService) {
        this.masterDataManagerService = _masterDataManagerService;
    }

    @CrossOrigin
    @RequestMapping(value={"/findDfbTeams"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TeamJson> findDfbTeams() {
        List dfbTeams = this.masterDataManagerService.findTeams(TeamType.DFB);
        return JsonBuilder.toJsonWithTeams(dfbTeams);
    }

    @CrossOrigin
    @RequestMapping(value={"/findFifaTeams"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TeamJson> findFifaTeams() {
        List fifaTeams = this.masterDataManagerService.findTeams(TeamType.FIFA);
        return JsonBuilder.toJsonWithTeams(fifaTeams);
    }

    @CrossOrigin
    @RequestMapping(value={"/teamvsteam"}, method={RequestMethod.GET})
    @ResponseBody
    public HistoryTeamVsTeamJson research(@RequestParam(value="homeTeam", required=true) long homeTeamId, @RequestParam(value="guestTeam", required=true) long guestTeamId) {
        Team homeTeam = this.masterDataManagerService.findTeamById(homeTeamId);
        Team guestTeam = this.masterDataManagerService.findTeamById(guestTeamId);
        List findMatches = this.seasonManagerService.findMatches(homeTeam, guestTeam);
        return HistoryTeamVsTeamJsonMapper.map(findMatches);
    }
}

