/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.awtools.basic.LoggerFactory;
import de.betoffice.openligadb.OpenligadbConnectionException;
import de.betoffice.openligadb.SportsdataStub;
import de.msiggi.sportsdata.webservices.ArrayOfMatchdata;
import de.msiggi.sportsdata.webservices.GetMatchdataByGroupLeagueSaisonDocument;
import de.msiggi.sportsdata.webservices.GetMatchdataByGroupLeagueSaisonResponseDocument;
import de.msiggi.sportsdata.webservices.Matchdata;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class OpenligadbRoundFinder {
    private static final Logger LOG = LoggerFactory.make();
    private String webserviceUrl;

    public void setWebserviceUrl(String _webserviceUrl) {
        this.webserviceUrl = _webserviceUrl;
    }

    public Matchdata[] findMatches(String leagueShortcut, String leagueSeason, int groupOrderId) throws OpenligadbConnectionException {
        try {
            SportsdataStub stub = new SportsdataStub(this.webserviceUrl);
            stub = StringUtils.isEmpty((String)this.webserviceUrl) ? new SportsdataStub() : new SportsdataStub(this.webserviceUrl);
            GetMatchdataByGroupLeagueSaisonDocument getMatchdataByGroupLeagueSaison2 = GetMatchdataByGroupLeagueSaisonDocument.Factory.newInstance();
            GetMatchdataByGroupLeagueSaisonDocument.GetMatchdataByGroupLeagueSaison addNewGetMatchdataByGroupLeagueSaison = getMatchdataByGroupLeagueSaison2.addNewGetMatchdataByGroupLeagueSaison();
            addNewGetMatchdataByGroupLeagueSaison.setLeagueShortcut(leagueShortcut);
            addNewGetMatchdataByGroupLeagueSaison.setLeagueSaison(leagueSeason);
            addNewGetMatchdataByGroupLeagueSaison.setGroupOrderID(groupOrderId);
            GetMatchdataByGroupLeagueSaisonResponseDocument matchdataByGroupLeagueSaison = stub.getMatchdataByGroupLeagueSaison(getMatchdataByGroupLeagueSaison2);
            GetMatchdataByGroupLeagueSaisonResponseDocument.GetMatchdataByGroupLeagueSaisonResponse getMatchdataByGroupLeagueSaisonResponse = matchdataByGroupLeagueSaison.getGetMatchdataByGroupLeagueSaisonResponse();
            ArrayOfMatchdata getMatchdataByGroupLeagueSaisonResult = getMatchdataByGroupLeagueSaisonResponse.getGetMatchdataByGroupLeagueSaisonResult();
            Matchdata[] matchdataArray = getMatchdataByGroupLeagueSaisonResult.getMatchdataArray();
            return matchdataArray;
        }
        catch (RemoteException ex) {
            LOG.error("There is a problem with the openligadb webservice. I catched a RemoteException: {}", (Object)ex.getMessage());
            throw new OpenligadbConnectionException(ex.getMessage(), ex);
        }
    }
}

