/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.awtools.basic.LoggerFactory;
import de.betoffice.openligadb.PlayerBuilder;
import de.msiggi.sportsdata.webservices.Goal;
import de.msiggi.sportsdata.webservices.Matchdata;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.storage.Player;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlayerSynchronize {
    private static final Logger LOG = LoggerFactory.make();
    private PlayerDao playerDao;

    @Autowired
    public void setPlayerDao(PlayerDao _playerDao) {
        this.playerDao = _playerDao;
    }

    public void sync(Matchdata[] matches) {
        for (Matchdata match : matches) {
            this.sync(match);
        }
    }

    public void sync(Matchdata match) {
        LOG.info("Player/Goalgetter sync: {} - {}", new Object[]{match.getNameTeam1(), match.getNameTeam2()});
        for (Goal goal : match.getGoals().getGoalArray()) {
            Optional player;
            if (goal.getGoalGetterID() == 0) {
                LOG.info("The goal with openligadb ID=[{}] does not define a goalgetter. The goalgetter is undefined/unknown.", (Object)goal.getGoalGetterID());
                continue;
            }
            if (StringUtils.isEmpty((String)goal.getGoalGetterName())) {
                LOG.info("The goal with openligadb ID=[{}] contains empty values.  name=[{}]", (Object)goal.getGoalGetterID(), (Object)goal.getGoalGetterName());
                player = new Player();
                player.setName("TODO: Find my name!");
                player.setVorname("John");
                player.setOpenligaid(Long.valueOf(goal.getGoalGetterID()));
                this.playerDao.save((Object)player);
                continue;
            }
            player = this.playerDao.findByOpenligaid((long)goal.getGoalGetterID());
            if (!player.isPresent()) {
                Player newPlayer = PlayerBuilder.build(goal);
                this.playerDao.save((Object)newPlayer);
                continue;
            }
            if (this.isEqual((Player)player.get(), goal)) continue;
            LOG.error("Player problem: Openligadb goalgetter name[{}] and betoffice player name[{}] are different. Problem found at openligadb goal [{}]", new Object[]{goal.getGoalGetterName(), ((Player)player.get()).getName(), goal.getGoalID()});
        }
    }

    private boolean isEqual(Player boPlayer, Goal goal) {
        return StringUtils.equalsIgnoreCase((String)boPlayer.getName(), (String)goal.getGoalGetterName());
    }
}

