/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.LocationBuilder;
import de.msiggi.sportsdata.webservices.Matchdata;
import de.winkler.betoffice.dao.LocationDao;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocationSynchronize {
    private static final Logger LOG = LoggerFactory.make();
    private LocationDao locationDao;

    @Autowired
    public void setLocationDao(LocationDao _locationDao) {
        this.locationDao = _locationDao;
    }

    public void sync(Matchdata[] matches) {
        for (Matchdata match : matches) {
            this.sync(match);
        }
    }

    public void sync(Matchdata match) {
        LOG.info("Location sync: {}:{}", new Object[]{match.getNameTeam1(), match.getNameTeam2()});
        if (match.getLocation().getLocationID() == 0) {
            LOG.info("The match with openligadb ID=[{}] does not define a knwon location. The location is undefined/unknown.", (Object)match.getMatchID());
        } else if (match.getLocation().getLocationStadium() == null || match.getLocation().getLocationCity() == null) {
            LOG.info("The location with openligadb ID=[{}] contains null values.  city=[{}], stadium=[{}]", new Object[]{match.getLocation().getLocationID(), match.getLocation().getLocationCity(), match.getLocation().getLocationStadium()});
        } else {
            Optional location = this.locationDao.findByOpenligaid((long)match.getLocation().getLocationID());
            if (!location.isPresent()) {
                Location matchLocation = LocationBuilder.build(match);
                this.locationDao.save((Object)matchLocation);
            } else if (!this.isEqual((Location)location.get(), match)) {
                LOG.info("Location problem: openligadb ID=[{}], name=[{}], city=[{}] is not equal to betoffice location name=[{}], city=[{}].", new Object[]{match.getLocation().getLocationID(), match.getLocation().getLocationStadium(), ((Location)location.get()).getName(), ((Location)location.get()).getCity()});
            }
        }
    }

    private boolean isEqual(Location boLocation, Matchdata match) {
        boolean name = StringUtils.equalsIgnoreCase((CharSequence)boLocation.getName(), (CharSequence)match.getLocation().getLocationStadium());
        boolean city = StringUtils.equalsIgnoreCase((CharSequence)boLocation.getCity(), (CharSequence)match.getLocation().getLocationCity());
        return name && city;
    }
}

