/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.service;

import de.betoffice.openligadb.GoalBuilder;
import de.betoffice.openligadb.LocationSynchronize;
import de.betoffice.openligadb.OpenligadbConnectionException;
import de.betoffice.openligadb.OpenligadbRoundFinder;
import de.betoffice.openligadb.OpenligadbToBetofficeBuilder;
import de.betoffice.openligadb.PlayerSynchronize;
import de.betoffice.service.OpenligadbUpdateService;
import de.msiggi.sportsdata.webservices.Matchdata;
import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.LocationDao;
import de.winkler.betoffice.dao.MatchDao;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.TeamDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="openligadbUpdateService")
public class DefaultOpenligadbUpdateService
implements OpenligadbUpdateService {
    private static final Logger LOG = LoggerFactory.make();
    private TeamDao teamDao;
    private SeasonDao seasonDao;
    private RoundDao roundDao;
    private MatchDao matchDao;
    private OpenligadbRoundFinder openligadbRoundFinder;
    private LocationDao locationDao;
    private PlayerDao playerDao;
    private GoalDao goalDao;
    private LocationSynchronize locationSynchronize;
    private PlayerSynchronize playerSynchronize;

    @Autowired
    public void setTeamDao(TeamDao _teamDao) {
        this.teamDao = _teamDao;
    }

    @Autowired
    public void setSeasonDao(SeasonDao _seasonDao) {
        this.seasonDao = _seasonDao;
    }

    @Autowired
    public void setRoundDao(RoundDao _roundDao) {
        this.roundDao = _roundDao;
    }

    @Autowired
    public void setMatchDao(MatchDao _matchDao) {
        this.matchDao = _matchDao;
    }

    @Autowired
    public void setOpenligadbRoundFinder(OpenligadbRoundFinder _openligadbRoundFinder) {
        this.openligadbRoundFinder = _openligadbRoundFinder;
    }

    @Autowired
    public void setLocationDao(LocationDao _locationDao) {
        this.locationDao = _locationDao;
    }

    @Autowired
    public void setPlayerDao(PlayerDao _playerDao) {
        this.playerDao = _playerDao;
    }

    @Autowired
    public void setGoalDao(GoalDao _goalDao) {
        this.goalDao = _goalDao;
    }

    @Autowired
    public void setLocationSynchronize(LocationSynchronize _locationSynchronize) {
        this.locationSynchronize = _locationSynchronize;
    }

    @Autowired
    public void setPlayerSynchronize(PlayerSynchronize _playerSynchronize) {
        this.playerSynchronize = _playerSynchronize;
    }

    @Override
    @Transactional
    public void updateRound(long seasonId, int roundIndex) {
        this.createOrUpdateRound(seasonId, roundIndex);
    }

    @Override
    @Transactional
    public void createOrUpdateRound(long seasonId, int roundIndex) {
        LOG.info("Start the openligadb update service for season id=[{}] and roundIndex=[{}]", (Object)seasonId, (Object)roundIndex);
        if (roundIndex < 0) {
            String error = "Round index to small!";
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        Season season = (Season)this.seasonDao.findById(seasonId);
        if (season == null) {
            String error = String.format("No season defined for id=[%s]", seasonId);
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        Group bundesliga = (Group)season.getGroups().iterator().next();
        Optional roundAtIndex = this.roundDao.findRound(season, roundIndex);
        GameList roundUnderWork = roundAtIndex.isPresent() ? (GameList)roundAtIndex.get() : this.createRound(season, bundesliga);
        Matchdata[] matches = null;
        try {
            matches = this.openligadbRoundFinder.findMatches(season.getChampionshipConfiguration().getOpenligaLeagueShortcut(), season.getChampionshipConfiguration().getOpenligaLeagueSeason(), roundIndex + 1);
        }
        catch (OpenligadbConnectionException ex) {
            LOG.error("Aborting the update process! {}", (Object)ex.getMessage(), (Object)ex.getCause());
            return;
        }
        if (matches == null || matches.length == 0) {
            String error = String.format("Aborting the update process! No matches found for LeagueShortcut=[%s], LeagueSeason=[%s], groupOrderId=[%d]", season.getChampionshipConfiguration().getOpenligaLeagueShortcut(), season.getChampionshipConfiguration().getOpenligaLeagueSeason(), roundIndex + 1);
            LOG.error(error);
            return;
        }
        if (roundUnderWork.getOpenligaid() == null) {
            roundUnderWork.setOpenligaid(Long.valueOf(matches[0].getGroupID()));
        } else {
            long openligaGroupid = matches[0].getGroupID();
            if (openligaGroupid != roundUnderWork.getOpenligaid()) {
                String error = String.format("Openligadb groupId=[%d] and the stored groupId of betoffice GameList [%d] are different.", openligaGroupid, roundUnderWork.getOpenligaid());
                LOG.error(error);
                throw new IllegalStateException(error);
            }
        }
        this.locationSynchronize.sync(matches);
        this.playerSynchronize.sync(matches);
        if (matches.length == 0) {
            LOG.info("The openligadb has no matches for betoffice! season id=[{}], roundIndex=[{}]", (Object)seasonId, (Object)roundIndex);
        }
        for (Matchdata match : matches) {
            Team boGuestTeam;
            Team boHomeTeam = this.findBoTeam(match.getIdTeam1());
            Optional boMatch = this.matchDao.find(roundUnderWork, boHomeTeam, boGuestTeam = this.findBoTeam(match.getIdTeam2()));
            Game matchUnderWork = boMatch.isPresent() ? this.updateMatch(match, (Game)boMatch.get()) : this.createMatch(bundesliga, roundUnderWork, match, boHomeTeam, boGuestTeam);
            Optional boLocation = this.locationDao.findByOpenligaid((long)match.getLocation().getLocationID());
            if (boLocation.isPresent()) {
                matchUnderWork.setLocation((Location)boLocation.get());
            } else {
                Location unknwonLocation = (Location)this.locationDao.findById(1L);
                matchUnderWork.setLocation(unknwonLocation);
            }
            for (de.msiggi.sportsdata.webservices.Goal goal : match.getGoals().getGoalArray()) {
                Optional boGoal = this.goalDao.findByOpenligaid((long)goal.getGoalID());
                if (boGoal.isPresent()) continue;
                Goal goalUnderWork = GoalBuilder.build(goal);
                Optional boPlayer = this.playerDao.findByOpenligaid((long)goal.getGoalGetterID());
                goalUnderWork.setGame(matchUnderWork);
                matchUnderWork.addGoal(goalUnderWork);
                goalUnderWork.setPlayer((Player)boPlayer.get());
                this.goalDao.save((Object)goalUnderWork);
            }
            this.matchDao.save(matchUnderWork);
        }
        Date bestRoundDate = roundUnderWork.findBestRoundDate();
        roundUnderWork.setDateTime(bestRoundDate);
        this.roundDao.save((Object)roundUnderWork);
    }

    private Game updateMatch(Matchdata match, Game matchUnderWork) {
        if (matchUnderWork.getOpenligaid() == null) {
            matchUnderWork.setOpenligaid(Long.valueOf(match.getMatchID()));
        } else if (matchUnderWork.getOpenligaid() != (long)match.getMatchID()) {
            String error = String.format("Openligadb matchId=[%d] and stored matchId of betoffice game [%d] are different.", match.getMatchID(), matchUnderWork.getOpenligaid());
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        OpenligadbToBetofficeBuilder.updateGameDate(matchUnderWork, match);
        OpenligadbToBetofficeBuilder.updateGameResult(matchUnderWork, match);
        return matchUnderWork;
    }

    private Game createMatch(Group bundesliga, GameList roundUnderWork, Matchdata match, Team boHomeTeam, Team boGuestTeam) {
        Game newMatch = OpenligadbToBetofficeBuilder.buildGame(match, boHomeTeam, boGuestTeam);
        newMatch.setGroup(bundesliga);
        newMatch.setOpenligaid(Long.valueOf(match.getMatchID()));
        this.matchDao.save(newMatch);
        roundUnderWork.addGame(newMatch);
        OpenligadbToBetofficeBuilder.updateGameResult(newMatch, match);
        return newMatch;
    }

    private GameList createRound(Season season, Group bundesliga) {
        GameList newRound = new GameList();
        newRound.setGroup(bundesliga);
        newRound.setSeason(season);
        newRound.setDateTime(new Date());
        season.addGameList(newRound);
        this.roundDao.save((Object)newRound);
        return newRound;
    }

    private Team findBoTeam(long openligaTeamId) {
        Optional boHomeTeam = this.teamDao.findByOpenligaid(openligaTeamId);
        if (!boHomeTeam.isPresent()) {
            String error = String.format("I did not a find a betoffice team for the openligadb team id [%d].", openligaTeamId);
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        return (Team)boHomeTeam.get();
    }
}

