/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.winkler.betoffice.service.DateTimeProvider;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DateTimeService {
    private static final DateTimeFormatter MATCH_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private final DateTimeProvider dateTimeProvider;

    @Autowired
    public DateTimeService(DateTimeProvider dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider;
    }

    public ZonedDateTime toDate(String matchDateTime) {
        ZoneId defaultZoneId = this.dateTimeProvider.defaultZoneId();
        LocalDateTime localDateTime = LocalDateTime.from(MATCH_DATETIME_FORMAT.parse(matchDateTime));
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, defaultZoneId);
        return zonedDateTime;
    }

    @Deprecated
    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        TimeZone timeZone = calendar.getTimeZone();
        ZoneId zone = timeZone.toZoneId();
        Date time = calendar.getTime();
        return time.toInstant().atZone(zone);
    }
}

