/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.GoalBuilder;
import de.betoffice.openligadb.LocationSynchronize;
import de.betoffice.openligadb.OpenligadbException;
import de.betoffice.openligadb.OpenligadbRoundFinder;
import de.betoffice.openligadb.OpenligadbToBetofficeBuilder;
import de.betoffice.openligadb.OpenligadbUpdateService;
import de.betoffice.openligadb.PlayerSynchronize;
import de.betoffice.openligadb.Result;
import de.betoffice.openligadb.json.OLDBGoal;
import de.betoffice.openligadb.json.OLDBMatch;
import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.LocationDao;
import de.winkler.betoffice.dao.MatchDao;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.TeamDao;
import de.winkler.betoffice.service.DateTimeProvider;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.util.LoggerFactory;
import java.time.LocalDate;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="openligadbUpdateService")
public class DefaultOpenligadbUpdateService
implements OpenligadbUpdateService {
    private static final Logger LOG = LoggerFactory.make();
    private static final Marker MARKER = MarkerFactory.getMarker((String)"OpenligadbUpdateService");
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private SeasonDao seasonDao;
    @Autowired
    private RoundDao roundDao;
    @Autowired
    private MatchDao matchDao;
    @Autowired
    private OpenligadbRoundFinder openligadbRoundFinder;
    @Autowired
    private OpenligadbToBetofficeBuilder openligadbToBetofficeBuilder;
    @Autowired
    private LocationDao locationDao;
    @Autowired
    private PlayerDao playerDao;
    @Autowired
    private GoalDao goalDao;
    @Autowired
    private LocationSynchronize locationSynchronize;
    @Autowired
    private PlayerSynchronize playerSynchronize;
    @Autowired
    private DateTimeProvider dateTimeProvider;

    @Override
    @Transactional
    public void updateRound(long seasonId, int roundIndex) {
        this.createOrUpdateRound(seasonId, roundIndex);
    }

    @Override
    @Transactional
    public void createOrUpdateRound(long seasonId, int roundIndex) {
        LOG.info("Start the openligadb update service for season id=[{}] and roundIndex=[{}]", (Object)seasonId, (Object)roundIndex);
        if (roundIndex < 0) {
            String error = "Round index to small!";
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        Season season = (Season)this.seasonDao.findById(seasonId);
        if (season == null) {
            String error = String.format("No season defined for id=[%s]", seasonId);
            LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        Group bundesliga = (Group)season.getGroups().iterator().next();
        Optional roundAtIndex = this.roundDao.findRound(season, roundIndex);
        GameList roundUnderWork = roundAtIndex.isPresent() ? (GameList)roundAtIndex.get() : this.createRound(season, bundesliga);
        Result<OLDBMatch[], OpenligadbException> matches = this.openligadbRoundFinder.findMatches(season.getChampionshipConfiguration().getOpenligaLeagueShortcut(), season.getChampionshipConfiguration().getOpenligaLeagueSeason(), roundIndex + 1);
        try {
            OLDBMatch[] oldbMatches = matches.map(t -> t).orElseThrow();
            if (oldbMatches == null || oldbMatches.length == 0) {
                LOG.error(this.toErrorMessage(roundIndex, season));
                return;
            }
            if (roundUnderWork.getOpenligaid() == null) {
                roundUnderWork.setOpenligaid(Long.valueOf(oldbMatches[0].getGroup().getGroupID().intValue()));
            } else {
                long openligaGroupid = oldbMatches[0].getGroup().getGroupID().intValue();
                if (openligaGroupid != roundUnderWork.getOpenligaid()) {
                    String error = String.format("Openligadb groupId=[%d] and the stored groupId of betoffice GameList [%d] are different.", openligaGroupid, roundUnderWork.getOpenligaid());
                    LOG.error(error);
                    throw new IllegalStateException(error);
                }
            }
            this.locationSynchronize.sync(oldbMatches);
            this.playerSynchronize.sync(oldbMatches);
            for (OLDBMatch match : oldbMatches) {
                Game matchUnderWork;
                Team boHomeTeam = this.findBoTeam(match.getTeam1().getTeamId().intValue());
                Team boGuestTeam = this.findBoTeam(match.getTeam2().getTeamId().intValue());
                boHomeTeam.setLogo(match.getTeam1().getTeamIconUrl());
                boGuestTeam.setLogo(match.getTeam2().getTeamIconUrl());
                Optional boMatch = this.matchDao.find(roundUnderWork, boHomeTeam, boGuestTeam);
                Game game = matchUnderWork = boMatch.isPresent() ? this.updateMatch(match, (Game)boMatch.get()) : this.createMatch(bundesliga, roundUnderWork, match, boHomeTeam, boGuestTeam);
                if (match.getLocation() != null) {
                    Optional boLocation = this.locationDao.findByOpenligaid((long)match.getLocation().getLocationID().intValue());
                    if (boLocation.isPresent()) {
                        matchUnderWork.setLocation((Location)boLocation.get());
                    } else {
                        Location unknwonLocation = (Location)this.locationDao.findById(1L);
                        matchUnderWork.setLocation(unknwonLocation);
                    }
                } else {
                    Location unknwonLocation = (Location)this.locationDao.findById(1L);
                    matchUnderWork.setLocation(unknwonLocation);
                }
                this.goalDao.deleteAll(matchUnderWork);
                boMatch.ifPresentOrElse(arg_0 -> ((MatchDao)this.matchDao).update(arg_0), () -> this.matchDao.persist((Object)matchUnderWork));
                if (boMatch.isPresent()) {
                    this.matchDao.update((Object)matchUnderWork);
                } else {
                    this.matchDao.persist((Object)matchUnderWork);
                }
                for (OLDBGoal goal : match.getGoals()) {
                    Optional boGoal = this.goalDao.findByOpenligaid((long)goal.getGoalID().intValue());
                    Optional boPlayer = this.playerDao.findByOpenligaid((long)goal.getGoalGetterID().intValue());
                    if (boPlayer.isEmpty()) {
                        LOG.warn(MARKER, "Spieler zu einem Tor nicht gefunden. Das Tor wird nicht abgespeichert. Spiel: " + match.getMatchDateTimeUTC() + " / " + match.getTeam1().getShortName() + ":" + match.getTeam2().getShortName());
                        continue;
                    }
                    Goal goalUnderWork = null;
                    if (boGoal.isPresent()) {
                        goalUnderWork = GoalBuilder.update(goal, (Goal)boGoal.get());
                        goalUnderWork.setPlayer((Player)boPlayer.get());
                        this.goalDao.persist((Object)goalUnderWork);
                        continue;
                    }
                    if (goal.getMatchMinute() == null) {
                        LOG.warn(MARKER, "Die Spielminute ist gleich 'null'. Das Tor wird nicht gespeichert. Spiel: " + match.getMatchDateTimeUTC() + " / " + match.getTeam1().getShortName() + ":" + match.getTeam2().getShortName());
                        continue;
                    }
                    goalUnderWork = GoalBuilder.build(goal);
                    goalUnderWork.setGame(matchUnderWork);
                    matchUnderWork.addGoal(goalUnderWork);
                    goalUnderWork.setPlayer((Player)boPlayer.get());
                    this.goalDao.update((Object)goalUnderWork);
                }
                this.matchDao.update((Object)matchUnderWork);
            }
        }
        catch (Exception ex) {
            LOG.error(this.toErrorMessage(roundIndex, season), ex.getCause());
            return;
        }
        LocalDate bestRoundDate = roundUnderWork.findBestRoundDate();
        roundUnderWork.setDateTime(bestRoundDate.atTime(0, 0).atZone(this.dateTimeProvider.defaultZoneId()));
        this.roundDao.update((Object)roundUnderWork);
    }

    private String toErrorMessage(int roundIndex, Season season) {
        return String.format("Aborting the update process! No matches found for LeagueShortcut=[%s], LeagueSeason=[%s], groupOrderId=[%d]", season.getChampionshipConfiguration().getOpenligaLeagueShortcut(), season.getChampionshipConfiguration().getOpenligaLeagueSeason(), roundIndex + 1);
    }

    private Game updateMatch(OLDBMatch match, Game matchUnderWork) {
        if (matchUnderWork.getOpenligaid() == null) {
            matchUnderWork.setOpenligaid(Long.valueOf(match.getMatchID().intValue()));
        } else if (matchUnderWork.getOpenligaid().longValue() != match.getMatchID().longValue()) {
            String error = String.format("Openligadb matchId=[%d] and stored matchId of betoffice game [%d] are different.", match.getMatchID(), matchUnderWork.getOpenligaid());
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        this.openligadbToBetofficeBuilder.updateGameDate(matchUnderWork, match);
        this.openligadbToBetofficeBuilder.updateGameResult(matchUnderWork, match);
        return matchUnderWork;
    }

    private Game createMatch(Group bundesliga, GameList roundUnderWork, OLDBMatch match, Team boHomeTeam, Team boGuestTeam) {
        Game newMatch = this.openligadbToBetofficeBuilder.buildGame(match, boHomeTeam, boGuestTeam);
        newMatch.setGroup(bundesliga);
        newMatch.setOpenligaid(Long.valueOf(match.getMatchID().intValue()));
        this.matchDao.persist((Object)newMatch);
        roundUnderWork.addGame(newMatch);
        this.openligadbToBetofficeBuilder.updateGameResult(newMatch, match);
        return newMatch;
    }

    private GameList createRound(Season season, Group bundesliga) {
        GameList newRound = new GameList();
        newRound.setGroup(bundesliga);
        newRound.setSeason(season);
        newRound.setDateTime(this.dateTimeProvider.currentDateTime());
        season.addGameList(newRound);
        this.roundDao.persist((Object)newRound);
        return newRound;
    }

    private Team findBoTeam(long openligaTeamId) {
        Optional boHomeTeam = this.teamDao.findByOpenligaid(openligaTeamId);
        if (!boHomeTeam.isPresent()) {
            String error = String.format("I did not a find a betoffice team for the openligadb team id [%d].", openligaTeamId);
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        return (Team)boHomeTeam.get();
    }
}

