/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.DateTimeService;
import de.betoffice.openligadb.json.OLDBMatch;
import de.betoffice.openligadb.json.OLDBMatchResult;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.Team;
import java.time.ZonedDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenligadbToBetofficeBuilder {
    private final DateTimeService dateTimeService;

    @Autowired
    public OpenligadbToBetofficeBuilder(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public Game buildGame(OLDBMatch match, Team boHomeTeam, Team boGuestTeam) {
        Game boMatch = new Game();
        ZonedDateTime zdt = this.dateTimeService.toDate(match.getMatchDateTime());
        boMatch.setDateTime(zdt);
        boMatch.setHomeTeam(boHomeTeam);
        boMatch.setGuestTeam(boGuestTeam);
        return boMatch;
    }

    public Game updateGameDate(Game game, OLDBMatch match) {
        game.setDateTime(this.dateTimeService.toDate(match.getMatchDateTime()));
        return game;
    }

    public Game updateGameResult(Game game, OLDBMatch matchData) {
        game.setPlayed(matchData.getMatchIsFinished().booleanValue());
        List<OLDBMatchResult> matchResults = matchData.getMatchResults();
        for (OLDBMatchResult matchResult : matchResults) {
            switch (matchResult.getResultTypeID()) {
                case 1: {
                    GameResult result = GameResult.of((int)matchResult.getPointsTeam1(), (int)matchResult.getPointsTeam2());
                    game.setHalfTimeGoals(result);
                    break;
                }
                case 2: {
                    game.setResult(matchResult.getPointsTeam1().intValue(), matchResult.getPointsTeam2().intValue());
                    break;
                }
            }
        }
        return game;
    }
}

