/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.PlayerBuilder;
import de.betoffice.openligadb.json.OLDBGoal;
import de.betoffice.openligadb.json.OLDBMatch;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlayerSynchronize {
    private static final Logger LOG = LoggerFactory.make();
    private PlayerDao playerDao;

    @Autowired
    public void setPlayerDao(PlayerDao _playerDao) {
        this.playerDao = _playerDao;
    }

    public void sync(OLDBMatch[] matches) {
        for (OLDBMatch match : matches) {
            this.sync(match);
        }
    }

    public void sync(OLDBMatch match) {
        LOG.info("Player/Goalgetter sync: {} - {}", new Object[]{match.getTeam1().getTeamName(), match.getTeam2().getTeamName()});
        for (OLDBGoal goal : match.getGoals()) {
            Optional player;
            if (goal.getGoalGetterID() == 0) {
                LOG.info("The goal with openligadb ID=[{}] does not define a goalgetter. The goalgetter is undefined/unknown.", (Object)goal.getGoalGetterID());
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)goal.getGoalGetterName())) {
                LOG.info("The goal with openligadb ID=[{}] contains empty values.  name=[{}]", (Object)goal.getGoalGetterID(), (Object)goal.getGoalGetterName());
                player = new Player();
                player.setName("TODO: Find my name!");
                player.setVorname("John");
                player.setOpenligaid((long)goal.getGoalGetterID());
                this.playerDao.persist((Object)player);
                continue;
            }
            player = this.playerDao.findByOpenligaid((long)goal.getGoalGetterID().intValue());
            if (!player.isPresent()) {
                Player newPlayer = PlayerBuilder.build(goal);
                this.playerDao.update((Object)newPlayer);
                continue;
            }
            if (this.isEqual((Player)player.get(), goal)) continue;
            LOG.error("Player problem: Openligadb goalgetter name[{}] and betoffice player name[{}] are different. Problem found at openligadb goal [{}]", new Object[]{goal.getGoalGetterName(), ((Player)player.get()).getName(), goal.getGoalID()});
        }
    }

    private boolean isEqual(Player boPlayer, OLDBGoal goal) {
        return StringUtils.equalsIgnoreCase((CharSequence)boPlayer.getName(), (CharSequence)StringUtils.trimToEmpty((String)goal.getGoalGetterName()));
    }
}

