/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.json.OLDBGoal;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.enums.GoalType;

public class GoalBuilder {
    public static Goal build(OLDBGoal openligadbGoal) {
        Goal boGoal = new Goal();
        boGoal.setOpenligaid(Long.valueOf(openligadbGoal.getGoalID().intValue()));
        GoalBuilder.setMinuteOrDefault(openligadbGoal, boGoal);
        boGoal.setComment(openligadbGoal.getComment() == null ? null : openligadbGoal.getComment().toString());
        boGoal.setResult(new GameResult(openligadbGoal.getScoreTeam1().intValue(), openligadbGoal.getScoreTeam2().intValue()));
        if (openligadbGoal.getIsOvertime().booleanValue()) {
            boGoal.setGoalType(GoalType.OVERTIME);
        } else if (openligadbGoal.getIsOwnGoal().booleanValue()) {
            boGoal.setGoalType(GoalType.OWNGOAL);
        } else if (openligadbGoal.getIsPenalty().booleanValue()) {
            boGoal.setGoalType(GoalType.PENALTY);
        } else {
            boGoal.setGoalType(GoalType.REGULAR);
        }
        return boGoal;
    }

    public static Goal update(OLDBGoal openligadbGoal, Goal boGoal) {
        GoalBuilder.setMinuteOrDefault(openligadbGoal, boGoal);
        boGoal.setComment(openligadbGoal.getComment() == null ? null : openligadbGoal.getComment().toString());
        boGoal.setResult(new GameResult(openligadbGoal.getScoreTeam1().intValue(), openligadbGoal.getScoreTeam2().intValue()));
        boGoal.setPlayer(null);
        return boGoal;
    }

    private static void setMinuteOrDefault(OLDBGoal oldbGoal, Goal boGoal) {
        boGoal.setMinute(Integer.valueOf(oldbGoal.getMatchMinute() == null ? -1 : oldbGoal.getMatchMinute()));
    }
}

