/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.APIUrl;
import de.betoffice.openligadb.OpenligadbException;
import de.betoffice.openligadb.Result;
import de.betoffice.openligadb.json.OLDBMatch;
import de.winkler.betoffice.util.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class OpenligadbRoundFinder {
    private static final Logger LOG = LoggerFactory.make();
    private APIUrl apiUrl = new APIUrl();
    @Autowired
    private RestTemplate restTemplate;

    public Result<OLDBMatch[], OpenligadbException> findMatches(String leagueShortcut, String leagueSeason, int roundIndex) {
        OpenligaRoundFinder finder = new OpenligaRoundFinder(this.apiUrl, this.restTemplate, leagueShortcut, leagueSeason, roundIndex);
        Result<OLDBMatch[], OpenligadbException> result = Result.attempt(finder);
        return result;
    }

    public void setApiUrl(APIUrl apiUrl) {
        this.apiUrl = apiUrl;
    }

    public APIUrl getApiUrl() {
        return this.apiUrl;
    }

    private static class OpenligaRoundFinder
    implements Result.CheckedSupplier<OLDBMatch[], OpenligadbException> {
        private final APIUrl apiUrl;
        private final RestTemplate restTemplate;
        private final String leagueShortcut;
        private final String leagueSeason;
        private final int roundIndex;

        OpenligaRoundFinder(APIUrl apiUrl, RestTemplate restTemplate, String leagueShortcut, String leagueSeason, int roundIndex) {
            this.apiUrl = apiUrl;
            this.restTemplate = restTemplate;
            this.leagueShortcut = leagueShortcut;
            this.leagueSeason = leagueSeason;
            this.roundIndex = roundIndex;
        }

        @Override
        public OLDBMatch[] get() throws OpenligadbException {
            try {
                String url = this.apiUrl.getMatchData(this.leagueShortcut, this.leagueSeason, this.roundIndex);
                LOG.info("Starting openligadb request: " + url);
                OLDBMatch[] matches = (OLDBMatch[])this.restTemplate.getForObject(url, OLDBMatch[].class, new Object[0]);
                return matches;
            }
            catch (RestClientException ex) {
                LOG.error("There is a problem with the openligadb REST API. I catched an exception: {}", (Object)ex.getMessage());
                throw new OpenligadbException(ex.getMessage(), ex);
            }
        }
    }
}

