/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.auth;

import de.betoffice.web.auth.BetofficeAuthenticationService;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.SecurityTokenJson;
import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.service.DateTimeProvider;
import de.winkler.betoffice.service.SecurityToken;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.User;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultBetofficeAuthenticationService
implements BetofficeAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBetofficeAuthenticationService.class);
    @Autowired
    private DateTimeProvider dateTimeProvider;
    @Autowired
    private AuthService authService;
    @Autowired
    private CommunityService communityService;

    @Override
    public SecurityTokenJson login(String user, String password, String sessionId, String address, String browserId) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Try to login: {}", (Object)user);
        }
        Nickname nickname = Nickname.of((String)user);
        SecurityToken securityToken = this.authService.login(nickname, password, sessionId, address, browserId);
        SecurityTokenJson stj = null;
        if (securityToken == null) {
            stj = new SecurityTokenJson();
            stj.setLoginTime(this.dateTimeProvider.currentDateTime());
            stj.setNickname(user);
            stj.setRole("no_authorization");
            stj.setToken("no_authorization");
        } else {
            stj = JsonBuilder.toJson(securityToken);
            if (LOG.isInfoEnabled()) {
                LOG.info("Login successful: user=[{}], token=[{}]", (Object)user, (Object)stj);
            }
        }
        return stj;
    }

    @Override
    public SecurityTokenJson logout(String nickname, String token) {
        Optional user = this.communityService.findUser(Nickname.of((String)nickname));
        SecurityToken securityToken = new SecurityToken(token, (User)user.get(), ((User)user.get()).getRoleTypes(), this.dateTimeProvider.currentDateTime());
        this.authService.logout(securityToken);
        return JsonBuilder.toJson(securityToken);
    }
}

