/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.web.json.SeasonJson;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.enums.SeasonType;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.List;

public class SeasonJsonMapper {
    public static SeasonJson map(Season season, SeasonJson seasonJson) {
        seasonJson.setId(season.getId());
        seasonJson.setName(season.getReference().getName());
        seasonJson.setYear(season.getReference().getYear());
        seasonJson.setSeasonType(season.getMode().toString());
        seasonJson.setTeamType(season.getTeamType().toString());
        if (season.getChampionshipConfiguration() != null) {
            seasonJson.setOpenligaLeagueSeason(season.getChampionshipConfiguration().getOpenligaLeagueSeason());
            seasonJson.setOpenligaLeagueShortcut(season.getChampionshipConfiguration().getOpenligaLeagueShortcut());
        }
        return seasonJson;
    }

    public static List<SeasonJson> map(List<Season> seasons) {
        return seasons.stream().map(SeasonJsonMapper::map).toList();
    }

    private static SeasonJson map(Season season) {
        return SeasonJsonMapper.map(season, new SeasonJson());
    }

    public static Season reverse(SeasonJson seasonJson, Season season) {
        season.setMode(SeasonType.valueOf((String)seasonJson.getSeasonType()));
        season.setTeamType(TeamType.valueOf((String)seasonJson.getTeamType()));
        season.setReference(SeasonReference.of((String)seasonJson.getYear(), (String)seasonJson.getName()));
        season.getChampionshipConfiguration().setOpenligaLeagueSeason(seasonJson.getOpenligaLeagueSeason());
        season.getChampionshipConfiguration().setOpenligaLeagueShortcut(seasonJson.getOpenligaLeagueShortcut());
        return season;
    }
}

