/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.season;

import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GameWithGoalsJson;
import de.betoffice.web.json.GroupTypeJson;
import de.betoffice.web.json.PingJson;
import de.betoffice.web.json.RoundAndTableJson;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.UserTableJson;
import de.betoffice.web.season.BetofficeService;
import de.betoffice.web.tipp.OfficeTippService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/office"})
public class SeasonController {
    @Autowired
    private BetofficeService betofficeService;
    @Autowired
    private OfficeTippService officeTippService;

    public SeasonController(BetofficeService betofficeService, OfficeTippService officeTippService) {
        this.betofficeService = betofficeService;
        this.officeTippService = officeTippService;
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET})
    public PingJson ping(HttpServletRequest request) {
        return this.betofficeService.ping();
    }

    @RequestMapping(value={"/season"}, method={RequestMethod.GET})
    public List<SeasonJson> findAllSeason(HttpServletResponse response) {
        return this.betofficeService.findAllSeason();
    }

    @RequestMapping(value={"/season/{seasonId}"}, method={RequestMethod.GET})
    public SeasonJson findSeasonById(@PathVariable(value="seasonId") Long seasonId, HttpServletResponse response) {
        return this.betofficeService.findSeasonById(seasonId);
    }

    @RequestMapping(value={"/season/{seasonId}/group"}, method={RequestMethod.GET})
    public List<GroupTypeJson> findGroupTypes(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeService.findAllGroups(seasonId);
    }

    @RequestMapping(value={"/season/{seasonId}/group/{groupTypeId}/round/all"}, method={RequestMethod.GET})
    public SeasonJson findAllRounds(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="groupTypeId") Long groupTypeId) {
        return this.betofficeService.findAllRounds(seasonId, groupTypeId);
    }

    @RequestMapping(value={"/season/{seasonId}/current"}, method={RequestMethod.GET})
    public RoundJson findNextTipp(@PathVariable(value="seasonId") Long seasonId) {
        return this.officeTippService.findTippRound(seasonId).orElse(null);
    }

    @RequestMapping(value={"/season/{seasonId}/round"}, method={RequestMethod.GET})
    public List<RoundJson> findRounds(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeService.findAllRounds(seasonId);
    }

    @RequestMapping(value={"/season/{seasonId}/round/{roundId}"}, method={RequestMethod.GET})
    public RoundJson findRound(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.findRound(seasonId, roundId);
    }

    @RequestMapping(value={"/season/{seasonId}/round/{roundId}/next"}, method={RequestMethod.GET})
    public RoundJson findNextRound(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.findNextRound(seasonId, roundId);
    }

    @RequestMapping(value={"/season/{seasonId}/round/{roundId}/prev"}, method={RequestMethod.GET})
    public RoundJson findPrevRound(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.findPrevRound(seasonId, roundId);
    }

    @RequestMapping(value={"/game/{gameId}"}, method={RequestMethod.GET})
    public GameJson findGame(@PathVariable(value="gameId") Long gameId) {
        return this.betofficeService.findGame(gameId);
    }

    @RequestMapping(value={"/game-details/{gameId}"}, method={RequestMethod.GET})
    public GameWithGoalsJson findGameDetails(@PathVariable(value="gameId") Long gameId) {
        return this.betofficeService.findDetailGame(gameId);
    }

    @RequestMapping(value={"/season/{seasonId}/roundtable/{roundId}/group/{groupTypeId}"}, method={RequestMethod.GET})
    public RoundAndTableJson findRoundTable(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId, @PathVariable(value="groupTypeId") Long groupTypeId) {
        return this.betofficeService.findRoundTable(seasonId, roundId, groupTypeId);
    }

    @RequestMapping(value={"/season/{seasonId}/roundtable/{roundId}/next"}, method={RequestMethod.GET})
    public RoundAndTableJson findNextRoundTable(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.findNextRoundTable(seasonId, roundId);
    }

    @RequestMapping(value={"/season/{seasonId}/roundtable/{roundId}/prev"}, method={RequestMethod.GET})
    public RoundAndTableJson findPrevRoundTable(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.findPrevRoundTable(seasonId, roundId);
    }

    @RequestMapping(value={"/ranking/season/{seasonId}"}, method={RequestMethod.GET})
    public UserTableJson findUserTableBySeason(@PathVariable(value="seasonId") Long seasonId) {
        return this.betofficeService.calcUserRanking(seasonId);
    }

    @RequestMapping(value={"/ranking/roundonly/{roundId}"}, method={RequestMethod.GET})
    public UserTableJson findUserTableByRoundOnly(@PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.calcUserRankingByRoundOnly(roundId);
    }

    @RequestMapping(value={"/ranking/round/{roundId}"}, method={RequestMethod.GET})
    public UserTableJson findUserTableByRound(@PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.calcUserRankingByRound(roundId);
    }

    @RequestMapping(value={"/ranking/round/{roundId}/next"}, method={RequestMethod.GET})
    public UserTableJson findUserTableByNextRound(@PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.calcUserRankingByNextRound(roundId);
    }

    @RequestMapping(value={"/ranking/round/{roundId}/prev"}, method={RequestMethod.GET})
    public UserTableJson findUserTableByPrevRound(@PathVariable(value="roundId") Long roundId) {
        return this.betofficeService.calcUserRankingByPrevRound(roundId);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Access denied")
    @ExceptionHandler(value={AccessDeniedException.class})
    public void forbidden() {
    }
}

