/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.security;

import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.SecurityToken;
import de.winkler.betoffice.storage.Nickname;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JWTAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private final AuthenticationManager authenticationManager;
    private final AuthService authService;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager, AuthService authService) {
        this.authenticationManager = authenticationManager;
        this.authService = authService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Nickname nickname = Nickname.of((String)request.getParameter("nickname"));
        String password = request.getParameter("password");
        String sessionid = request.getSession().getId();
        String ipaddress = request.getRemoteAddr();
        String browserid = request.getHeader("User-Agent");
        if (browserid == null) {
            browserid = "User-Agent-Unknown";
        }
        this.authService.login(nickname, password, password, ipaddress, browserid);
        return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)nickname, (Object)password, new ArrayList()));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication auth) {
        SecurityToken token = (SecurityToken)this.authService.findTokenByNickname(Nickname.of((String)auth.getName())).orElseThrow();
        response.addHeader("Authorization", "Bearer " + String.valueOf(token));
    }
}

