/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.security;

import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.storage.Session;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JWTAuthorizationFilter
extends BasicAuthenticationFilter {
    private final AuthService authService;

    public JWTAuthorizationFilter(AuthenticationManager authManager, AuthService authService) {
        super(authManager);
        this.authService = authService;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String header = req.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(req);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null) {
            Optional validateSession = this.authService.validateSession(token.replace("Bearer ", ""));
            if (validateSession.isPresent()) {
                List roleTypes = ((Session)validateSession.get()).getUser().getRoleTypes();
                List authorities = roleTypes.stream().map(Enum::name).map(role -> "ROLE_" + role).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
                String nickname = ((Session)validateSession.get()).getNickname();
                return new UsernamePasswordAuthenticationToken((Object)nickname, null, authorities);
            }
            return null;
        }
        return null;
    }
}

