/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.research;

import de.betoffice.web.json.HistoryTeamVsTeamJson;
import de.betoffice.web.json.HistoryTeamVsTeamJsonMapper;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.TeamJson;
import de.betoffice.web.json.builder.TeamJsonMapper;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/office/research"})
public class ResearchController {
    private final SeasonManagerService seasonManagerService;
    private final MasterDataManagerService masterDataManagerService;

    public ResearchController(SeasonManagerService seasonManagerService, MasterDataManagerService masterDataManagerService) {
        this.seasonManagerService = seasonManagerService;
        this.masterDataManagerService = masterDataManagerService;
    }

    @RequestMapping(value={"/team/dfb"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TeamJson> findDfbTeams() {
        List dfbTeams = this.masterDataManagerService.findTeams(TeamType.DFB);
        return JsonBuilder.toJsonWithTeams(dfbTeams);
    }

    @RequestMapping(value={"/team/fifa"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TeamJson> findFifaTeams() {
        List fifaTeams = this.masterDataManagerService.findTeams(TeamType.FIFA);
        return JsonBuilder.toJsonWithTeams(fifaTeams);
    }

    @RequestMapping(value={"/team-search"}, method={RequestMethod.GET}, headers={"Content-type=application/json"})
    public List<TeamJson> findTeams(@RequestParam(name="filter", required=false) String teamFilter, @RequestParam(name="type", required=false) TeamType teamType) {
        return TeamJsonMapper.map(this.masterDataManagerService.findTeams(Optional.ofNullable(teamType), teamFilter));
    }

    @RequestMapping(value={"/game/team-vs-team"}, method={RequestMethod.GET})
    @ResponseBody
    public HistoryTeamVsTeamJson research(@RequestParam(value="homeTeam", required=true) long homeTeamId, @RequestParam(value="guestTeam", required=true) long guestTeamId, @RequestParam(value="spin", required=false) Boolean spin, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Team homeTeam = this.masterDataManagerService.findTeamById(homeTeamId);
        Team guestTeam = this.masterDataManagerService.findTeamById(guestTeamId);
        List findMatches = null;
        findMatches = spin == null ? this.seasonManagerService.findMatches(homeTeam, guestTeam, limit) : this.seasonManagerService.findMatches(homeTeam, guestTeam, spin.booleanValue(), limit);
        return HistoryTeamVsTeamJsonMapper.map(findMatches);
    }

    @RequestMapping(value={"/game/team"}, method={RequestMethod.GET})
    @ResponseBody
    public HistoryTeamVsTeamJson researchByTeam(@RequestParam(value="team", required=true) long teamId, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Team team = this.masterDataManagerService.findTeamById(teamId);
        List matches = this.seasonManagerService.findMatches(team, limit);
        return HistoryTeamVsTeamJsonMapper.map(matches);
    }

    @RequestMapping(value={"/game/home-team"}, method={RequestMethod.GET})
    @ResponseBody
    public HistoryTeamVsTeamJson researchByHomeTeam(@RequestParam(value="team", required=true) long teamId, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Team team = this.masterDataManagerService.findTeamById(teamId);
        List matches = this.seasonManagerService.findMatchesWithHomeTeam(team, limit);
        return HistoryTeamVsTeamJsonMapper.map(matches);
    }

    @RequestMapping(value={"/game/guest-team"}, method={RequestMethod.GET})
    @ResponseBody
    public HistoryTeamVsTeamJson researchByGuestTeam(@RequestParam(value="team", required=true) long teamId, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        Team team = this.masterDataManagerService.findTeamById(teamId);
        List matches = this.seasonManagerService.findMatchesWithGuestTeam(team, limit);
        return HistoryTeamVsTeamJsonMapper.map(matches);
    }
}

