/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.security;

import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.User;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = Logger.getLogger(CustomAuthenticationProvider.class.getName());
    private final AuthService authService;

    @Autowired
    public CustomAuthenticationProvider(AuthService authService) {
        this.authService = authService;
    }

    @Transactional
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Nickname nickname = Nickname.of((String)authentication.getName());
        Object credentials = authentication.getCredentials();
        LOG.info(() -> "credentials class: " + String.valueOf(credentials.getClass()));
        if (!(credentials instanceof String)) {
            return null;
        }
        String password = credentials.toString();
        Object details = authentication.getDetails();
        String ipaddress = null;
        String browserid = null;
        this.authService.login(nickname, password, password, ipaddress, browserid);
        User user = (User)this.authService.findByNickname(nickname).orElseThrow(() -> new BadCredentialsException(String.format("Authentication failed for nickname=[%1s].", nickname.value())));
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority("USER"));
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)nickname, (Object)password, grantedAuthorities);
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

