/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.tipp;

import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.tipp.OfficeTippService;
import de.betoffice.web.tipp.SubmitTippRoundJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/office"})
public class TippController {
    private final OfficeTippService officeTippService;

    @Autowired
    public TippController(OfficeTippService officeTippService) {
        this.officeTippService = officeTippService;
    }

    @RequestMapping(value={"/tipp/{roundId}/{nickName}"}, method={RequestMethod.GET})
    public RoundJson findTipp(@PathVariable(value="roundId") Long roundId, @PathVariable(value="nickName") String nickName) {
        return this.officeTippService.findTipp(roundId, nickName);
    }

    @RequestMapping(value={"/tipp/{seasonId}/{nickname}/current"}, method={RequestMethod.GET})
    public RoundJson findCurrentTipp(@PathVariable(value="seasonId") Long seasonId, @PathVariable(value="nickname") String nickName) {
        return this.officeTippService.findCurrentTipp(seasonId, nickName).orElse(null);
    }

    @RequestMapping(value={"/tipp/{roundId}/{nickName}/next"}, method={RequestMethod.GET})
    public RoundJson findNextTipp(@PathVariable(value="roundId") Long roundId, @PathVariable(value="nickName") String nickName) {
        return this.officeTippService.findNextTipp(roundId, nickName).orElse(null);
    }

    @RequestMapping(value={"/tipp/{roundId}/{nickName}/prev"}, method={RequestMethod.GET})
    public RoundJson findPrevTipp(@PathVariable(value="roundId") Long roundId, @PathVariable(value="nickName") String nickName) {
        return this.officeTippService.findPrevTipp(roundId, nickName).orElse(null);
    }

    @RequestMapping(value={"/tipp/submit"}, method={RequestMethod.POST}, headers={"Content-type=application/json"})
    public RoundJson submitTipp(@RequestBody SubmitTippRoundJson tippRoundJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="betofficeNickname") String nickname) {
        return this.officeTippService.submitTipp(token, tippRoundJson);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Access denied")
    @ExceptionHandler(value={AccessDeniedException.class})
    public void forbidden() {
    }
}

