/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.userprofile;

import de.betoffice.web.json.UserProfileJson;
import de.betoffice.web.json.builder.UserProfileJsonMapper;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.storage.Nickname;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/office"})
public class UserProfileController {
    private final CommunityService communityService;

    public UserProfileController(CommunityService communityService) {
        this.communityService = communityService;
    }

    @Secured(value={"ROLE_TIPPER", "ROLE_ADMIN"})
    @PreAuthorize(value="@betofficeAuthorizationService.validateSession(#headerToken, #nickname)")
    @GetMapping(value={"/profile/{nickname}"}, headers={"Content-type=application/json"})
    public ResponseEntity<UserProfileJson> findProfile(@PathVariable(value="nickname") String nickname, @RequestHeader(value="betofficeToken") String headerToken, @RequestHeader(value="betofficeNickname") String headerNickname) {
        return ResponseEntity.of(this.communityService.findUser(Nickname.of((String)headerNickname)).map(UserProfileJsonMapper::map));
    }

    @Secured(value={"ROLE_TIPPER", "ROLE_ADMIN"})
    @PostMapping(value={"/profile/{nickname}"}, headers={"Content-type=application/json"})
    public ResponseEntity<UserProfileJson> updateProfile(@PathVariable(value="nickname") String nickname, @RequestHeader(value="betofficeToken") String headerToken, @RequestHeader(value="betofficeNickname") String headerNickname, @RequestBody UserProfileJson userProfileJson) {
        return ResponseEntity.of(UserProfileJsonMapper.map(this.communityService.updateUser(false, Nickname.of((String)nickname), userProfileJson.getName(), userProfileJson.getSurname(), userProfileJson.getMail(), userProfileJson.isEmailNotificationEnabled(), userProfileJson.getPhone())));
    }

    @Secured(value={"ROLE_TIPPER", "ROLE_ADMIN"})
    @PostMapping(value={"/profile/{nickname}/resubmit-confirmation-mail"}, headers={"Content-type=application/json"})
    public ResponseEntity<UserProfileJson> resubmitConfirmationMail(@PathVariable(value="nickname") String nickname, @RequestHeader(value="betofficeToken") String headerToken, @RequestHeader(value="betofficeNickname") String headerNickname) {
        return ResponseEntity.of(UserProfileJsonMapper.map(this.communityService.resubmitConfirmationMail(Nickname.of((String)nickname))));
    }

    @Secured(value={"ROLE_TIPPER", "ROLE_ADMIN"})
    @PostMapping(value={"/profile/{nickname}/confirm-update/{changeToken}"}, headers={"Content-type=text/plain"})
    public ResponseEntity<UserProfileJson> confirmUpdateProfile(@PathVariable(value="nickname") String nickname, @PathVariable(value="changeToken") String changeToken, @RequestBody String changeTokenAsBody, @RequestHeader(value="betofficeToken") String headerToken, @RequestHeader(value="betofficeNickname") String headerNickname) {
        return ResponseEntity.of(UserProfileJsonMapper.map(this.communityService.findUserByChangeToken(changeToken).flatMap(u -> this.communityService.confirmMailAddressChange(u.getNickname(), changeToken))));
    }

    @Secured(value={"ROLE_TIPPER", "ROLE_ADMIN"})
    @PostMapping(value={"/profile/{nickname}/abort-update"}, headers={"Content-type=text/plain"})
    public ResponseEntity<UserProfileJson> abortUpdateProfile(@PathVariable(value="nickname") String nickname, @RequestHeader(value="betofficeToken") String headerToken, @RequestHeader(value="betofficeNickname") String headerNickname) {
        return ResponseEntity.of(UserProfileJsonMapper.map(this.communityService.findUser(Nickname.of((String)nickname)).flatMap(u -> this.communityService.abortMailAddressChange(u.getNickname()))));
    }
}

